/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorState;
import com.facebook.presto.spi.function.GroupedAccumulatorState;
import java.util.function.Supplier;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.openjdk.jol.info.ClassLayout;

public final class GroupedHiveAccumulatorState
implements GroupedAccumulatorState,
HiveAccumulatorState {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(GroupedHiveAccumulatorState.class).instanceSize();
    private final Supplier<GenericUDAFEvaluator.AggregationBuffer> bufferSupplier;
    private ObjectBigArray<GenericUDAFEvaluator.AggregationBuffer> buffers = new ObjectBigArray();
    private long groupId;

    public GroupedHiveAccumulatorState(Supplier<GenericUDAFEvaluator.AggregationBuffer> bufferSupplier) {
        this.bufferSupplier = bufferSupplier;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public void ensureCapacity(long size) {
        this.buffers.ensureCapacity(size);
    }

    @Override
    public GenericUDAFEvaluator.AggregationBuffer getAggregationBuffer() {
        GenericUDAFEvaluator.AggregationBuffer buffer = (GenericUDAFEvaluator.AggregationBuffer)this.buffers.get(this.groupId);
        if (buffer == null) {
            this.buffers.set(this.groupId, (Object)this.bufferSupplier.get());
        }
        return (GenericUDAFEvaluator.AggregationBuffer)this.buffers.get(this.groupId);
    }

    @Override
    public void setAggregationBuffer(GenericUDAFEvaluator.AggregationBuffer buffer) {
        this.buffers.set(this.groupId, (Object)buffer);
    }

    public long getEstimatedSize() {
        return INSTANCE_SIZE + this.buffers.sizeOf();
    }
}

