/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.hive.functions.ForHiveFunction;
import com.facebook.presto.hive.functions.FunctionRegistry;
import com.facebook.presto.hive.functions.HiveFunctionRegistry;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class StaticHiveFunctionRegistry
implements HiveFunctionRegistry {
    private final ClassLoader classLoader;

    @Inject
    public StaticHiveFunctionRegistry(@ForHiveFunction ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public Class<?> getClass(QualifiedObjectName name) throws ClassNotFoundException {
        Class clazz;
        ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);
        try {
            clazz = FunctionRegistry.getFunctionInfo(name.getObjectName()).getFunctionClass();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NullPointerException | SemanticException e) {
                throw new ClassNotFoundException("Class of function " + name + " not found", e);
            }
        }
        ignored.close();
        return clazz;
    }
}

