/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.type;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class PrestoTypes {
    private PrestoTypes() {
    }

    public static DecimalType createDecimalType(TypeSignature type) {
        Objects.requireNonNull(type);
        Preconditions.checkArgument(("decimal".equals(type.getBase()) && type.getParameters().size() == 2 ? 1 : 0) != 0, (Object)("Invalid decimal type " + type));
        int precision = ((TypeSignatureParameter)type.getParameters().get(0)).getLongLiteral().intValue();
        int scale = ((TypeSignatureParameter)type.getParameters().get(1)).getLongLiteral().intValue();
        return DecimalType.createDecimalType((int)precision, (int)scale);
    }

    public static Type fromObjectInspector(ObjectInspector inspector, TypeManager typeManager) {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return PrestoTypes.fromPrimitive((PrimitiveObjectInspector)inspector);
            }
            case LIST: {
                Preconditions.checkArgument((boolean)(inspector instanceof ListObjectInspector));
                return PrestoTypes.fromList((ListObjectInspector)inspector, typeManager);
            }
            case MAP: {
                Preconditions.checkArgument((boolean)(inspector instanceof MapObjectInspector));
                return PrestoTypes.fromMap((MapObjectInspector)inspector, typeManager);
            }
            case STRUCT: {
                Preconditions.checkArgument((boolean)(inspector instanceof StructObjectInspector));
                return PrestoTypes.fromStruct((StructObjectInspector)inspector, typeManager);
            }
        }
        throw HiveFunctionErrorCode.unsupportedType(inspector);
    }

    private static Type fromPrimitive(PrimitiveObjectInspector inspector) {
        switch (inspector.getPrimitiveCategory()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                return TinyintType.TINYINT;
            }
            case SHORT: {
                return SmallintType.SMALLINT;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
        }
        PrimitiveTypeInfo typeInfo = inspector.getTypeInfo();
        if (typeInfo instanceof CharTypeInfo) {
            int length = ((CharTypeInfo)typeInfo).getLength();
            return CharType.createCharType((long)length);
        }
        if (typeInfo instanceof VarcharTypeInfo) {
            int length = ((VarcharTypeInfo)typeInfo).getLength();
            return VarcharType.createVarcharType((int)length);
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            DecimalTypeInfo decimal = (DecimalTypeInfo)typeInfo;
            return DecimalType.createDecimalType((int)decimal.getPrecision(), (int)decimal.getScale());
        }
        throw HiveFunctionErrorCode.unsupportedType((ObjectInspector)inspector);
    }

    private static Type fromList(ListObjectInspector inspector, TypeManager typeManager) {
        ObjectInspector elementInspector = inspector.getListElementObjectInspector();
        return new ArrayType(PrestoTypes.fromObjectInspector(elementInspector, typeManager));
    }

    private static Type fromMap(MapObjectInspector inspector, TypeManager typeManager) {
        Type keyType = PrestoTypes.fromObjectInspector(inspector.getMapKeyObjectInspector(), typeManager);
        Type valueType = PrestoTypes.fromObjectInspector(inspector.getMapValueObjectInspector(), typeManager);
        return typeManager.getType(new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())}));
    }

    private static Type fromStruct(StructObjectInspector inspector, TypeManager typeManager) {
        List fields = inspector.getAllStructFieldRefs().stream().map(sf -> RowType.field((String)sf.getFieldName(), (Type)PrestoTypes.fromObjectInspector(sf.getFieldObjectInspector(), typeManager))).collect(Collectors.toList());
        return RowType.from(fields);
    }
}

