/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorState;
import com.facebook.presto.hive.functions.type.BlockInputDecoder;
import com.facebook.presto.hive.functions.type.BlockInputDecoders;
import com.facebook.presto.hive.functions.type.ObjectEncoder;
import com.facebook.presto.hive.functions.type.ObjectEncoders;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import java.util.function.Supplier;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveAccumulatorStateSerializer
implements AccumulatorStateSerializer<HiveAccumulatorState> {
    private final Supplier<GenericUDAFEvaluator> partialEvaluatorSupplier;
    private final Supplier<GenericUDAFEvaluator> finalEvaluatorSupplier;
    private final Type type;
    private final ObjectEncoder encoder;
    private final BlockInputDecoder decoder;

    public HiveAccumulatorStateSerializer(Supplier<GenericUDAFEvaluator> partialEvaluatorSupplier, Supplier<GenericUDAFEvaluator> finalEvaluatorSupplier, Type type, ObjectInspector inspector) {
        this.partialEvaluatorSupplier = partialEvaluatorSupplier;
        this.finalEvaluatorSupplier = finalEvaluatorSupplier;
        this.type = type;
        this.encoder = ObjectEncoders.createEncoder(type, inspector);
        this.decoder = BlockInputDecoders.createBlockInputDecoder(inspector, type);
    }

    public Type getSerializedType() {
        return this.type;
    }

    public void serialize(HiveAccumulatorState state, BlockBuilder out) {
        try {
            GenericUDAFEvaluator.AggregationBuffer buf = state.getAggregationBuffer();
            Object partial = this.partialEvaluatorSupplier.get().terminatePartial(buf);
            TypeUtils.writeNativeValue((Type)this.type, (BlockBuilder)out, (Object)this.encoder.encode(partial));
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.executionError(e);
        }
    }

    public void deserialize(Block block, int index, HiveAccumulatorState state) {
        try {
            GenericUDAFEvaluator.AggregationBuffer buf = this.finalEvaluatorSupplier.get().getNewAggregationBuffer();
            Object partial = this.decoder.decode(block, index);
            this.finalEvaluatorSupplier.get().merge(buf, partial);
            state.setAggregationBuffer(buf);
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.executionError(e);
        }
    }
}

