/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.hive.functions.ForHiveFunction;
import com.facebook.presto.hive.functions.FunctionRegistry;
import com.facebook.presto.hive.functions.HiveFunctionRegistry;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class StaticHiveFunctionRegistry
implements HiveFunctionRegistry {
    private final ClassLoader classLoader;

    @Inject
    public StaticHiveFunctionRegistry(@ForHiveFunction ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<?> getClass(QualifiedObjectName name) throws ClassNotFoundException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class clazz = FunctionRegistry.getFunctionInfo(name.getObjectName()).getFunctionClass();
            return clazz;
        }
        catch (NullPointerException | SemanticException e) {
            throw new ClassNotFoundException("Class of function " + name + " not found", e);
        }
    }
}

