/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.type;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DuplicateMapKeyException;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.block.SingleRowBlockWriter;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.type.DecimalUtils;
import com.facebook.presto.hive.functions.type.ObjectEncoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

public final class ObjectEncoders {
    private ObjectEncoders() {
    }

    public static ObjectEncoder createEncoder(Type type, ObjectInspector inspector) {
        String base;
        switch (base = type.getTypeSignature().getBase()) {
            case "bigint": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> (Long)o);
            }
            case "integer": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> ((Integer)o).longValue());
            }
            case "smallint": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> ((Short)o).longValue());
            }
            case "tinyint": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> ((Byte)o).longValue());
            }
            case "boolean": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> (Boolean)o);
            }
            case "date": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> ((Date)o).getTime());
            }
            case "decimal": {
                if (Decimals.isShortDecimal((Type)type)) {
                    DecimalType decimalType = (DecimalType)type;
                    return ObjectEncoders.compose(ObjectEncoders.decimal(inspector), o -> DecimalUtils.encodeToLong((BigDecimal)o, decimalType));
                }
                if (!Decimals.isLongDecimal((Type)type)) break;
                DecimalType decimalType = (DecimalType)type;
                return ObjectEncoders.compose(ObjectEncoders.decimal(inspector), o -> DecimalUtils.encodeToSlice((BigDecimal)o, decimalType));
            }
            case "real": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> Float.floatToRawIntBits(((Number)o).floatValue()));
            }
            case "double": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> (Double)o);
            }
            case "timestamp": {
                Preconditions.checkArgument((boolean)(inspector instanceof PrimitiveObjectInspector));
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> ((Timestamp)o).getTime());
            }
            case "varbinary": {
                if (!(inspector instanceof BinaryObjectInspector)) break;
                return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> Slices.wrappedBuffer((byte[])((byte[])o)));
            }
            case "varchar": {
                if (inspector instanceof StringObjectInspector) {
                    return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> Slices.utf8Slice((String)o.toString()));
                }
                if (!(inspector instanceof HiveVarcharObjectInspector)) break;
                return ObjectEncoders.compose(o -> ((HiveVarcharObjectInspector)inspector).getPrimitiveJavaObject(o).getValue(), o -> Slices.utf8Slice((String)((String)o)));
            }
            case "char": {
                if (inspector instanceof StringObjectInspector) {
                    return ObjectEncoders.compose(ObjectEncoders.primitive(inspector), o -> Slices.utf8Slice((String)o.toString()));
                }
                if (!(inspector instanceof HiveCharObjectInspector)) break;
                return ObjectEncoders.compose(o -> ((HiveCharObjectInspector)inspector).getPrimitiveJavaObject(o).getValue(), o -> Slices.utf8Slice((String)((String)o)));
            }
            case "row": {
                return StructObjectEncoder.create(type, inspector);
            }
            case "array": {
                return ListObjectEncoder.create(type, inspector);
            }
            case "map": {
                return MapObjectEncoder.create(type, inspector);
            }
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    private static ObjectEncoder compose(Function<Object, Object> inspector, Function<Object, Object> encoder) {
        return o -> {
            Object inspected;
            if (o != null && (inspected = inspector.apply(o)) != null) {
                return encoder.apply(inspected);
            }
            return null;
        };
    }

    private static Function<Object, Object> primitive(ObjectInspector inspector) {
        return arg_0 -> ((PrimitiveObjectInspector)((PrimitiveObjectInspector)inspector)).getPrimitiveJavaObject(arg_0);
    }

    private static Function<Object, Object> decimal(ObjectInspector inspector) {
        return o -> ((HiveDecimalObjectInspector)inspector).getPrimitiveJavaObject(o).bigDecimalValue();
    }

    private static BlockObjectWriter createBlockObjectWriter(ObjectEncoder encoder, Type type) {
        return new SimpleBlockObjectWriter(encoder, type);
    }

    private static class SimpleBlockObjectWriter
    implements BlockObjectWriter {
        private final ObjectEncoder objectEncoder;
        private final Type objectType;

        private SimpleBlockObjectWriter(ObjectEncoder objectEncoder, Type objectType) {
            this.objectEncoder = Objects.requireNonNull(objectEncoder, "objectEncoder is null");
            this.objectType = Objects.requireNonNull(objectType, "objectType is null");
        }

        @Override
        public void write(BlockBuilder out, Object object) {
            Object encoded;
            if (object != null && (encoded = this.objectEncoder.encode(object)) != null) {
                TypeUtils.writeNativeValue((Type)this.objectType, (BlockBuilder)out, (Object)encoded);
                return;
            }
            out.appendNull();
        }
    }

    private static interface BlockObjectWriter {
        public void write(BlockBuilder var1, Object var2);
    }

    public static class StructObjectEncoder
    implements ObjectEncoder {
        private final RowType type;
        private final StructObjectInspector inspector;
        private final List<BlockObjectWriter> fieldWriters;

        public static StructObjectEncoder create(Type type, Object inspector) {
            Preconditions.checkArgument((type instanceof RowType && inspector instanceof StructObjectInspector ? 1 : 0) != 0);
            return new StructObjectEncoder((RowType)type, (StructObjectInspector)inspector);
        }

        private static BlockObjectWriter createFieldBlockObjectWriter(Type type, StructField field) {
            ObjectEncoder encoder = ObjectEncoders.createEncoder(type, field.getFieldObjectInspector());
            return ObjectEncoders.createBlockObjectWriter(encoder, type);
        }

        public StructObjectEncoder(RowType type, StructObjectInspector inspector) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.inspector = Objects.requireNonNull(inspector, "inspector is null");
            this.fieldWriters = Streams.zip(type.getFields().stream().map(RowType.Field::getType), inspector.getAllStructFieldRefs().stream(), StructObjectEncoder::createFieldBlockObjectWriter).collect(Collectors.toList());
        }

        @Override
        public Object encode(Object object) {
            if (object == null) {
                return null;
            }
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.type));
            RowBlockBuilder rowBlockBuilder = (RowBlockBuilder)pageBuilder.getBlockBuilder(0);
            SingleRowBlockWriter blockBuilder = rowBlockBuilder.beginBlockEntry();
            List fieldObjects = this.inspector.getStructFieldsDataAsList(object);
            int totalNumField = this.fieldWriters.size();
            int numField = fieldObjects.size();
            for (int i = 0; i < totalNumField; ++i) {
                this.fieldWriters.get(i).write((BlockBuilder)blockBuilder, i < numField ? fieldObjects.get(i) : null);
            }
            rowBlockBuilder.closeEntry();
            pageBuilder.declarePosition();
            return this.type.getObject((Block)rowBlockBuilder, rowBlockBuilder.getPositionCount() - 1);
        }
    }

    public static class MapObjectEncoder
    implements ObjectEncoder {
        private final MapType mapType;
        private final MapObjectInspector mapObjectInspector;
        private final BlockObjectWriter keyWriter;
        private final BlockObjectWriter valueWriter;

        public static MapObjectEncoder create(Type type, Object inspector) {
            Preconditions.checkArgument((type instanceof MapType && inspector instanceof MapObjectInspector ? 1 : 0) != 0);
            return new MapObjectEncoder((MapType)type, (MapObjectInspector)inspector);
        }

        private MapObjectEncoder(MapType type, MapObjectInspector inspector) {
            this.mapType = Objects.requireNonNull(type, "mapType is null");
            this.mapObjectInspector = Objects.requireNonNull(inspector, "inspector is null");
            Type keyType = type.getKeyType();
            Type valueType = type.getValueType();
            ObjectEncoder keyEncoder = ObjectEncoders.createEncoder(keyType, inspector.getMapKeyObjectInspector());
            ObjectEncoder valueEncoder = ObjectEncoders.createEncoder(valueType, inspector.getMapValueObjectInspector());
            this.keyWriter = Objects.requireNonNull(ObjectEncoders.createBlockObjectWriter(keyEncoder, keyType), "keyWriter is null");
            this.valueWriter = Objects.requireNonNull(ObjectEncoders.createBlockObjectWriter(valueEncoder, valueType), "valueWriter is null");
        }

        @Override
        public Object encode(Object object) {
            if (object == null) {
                return null;
            }
            Map rawMap = this.mapObjectInspector.getMap(object);
            MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)this.mapType.createBlockBuilder(null, rawMap.size());
            SingleMapBlockWriter blockBuilder = mapBlockBuilder.beginBlockEntry();
            for (Map.Entry entry : rawMap.entrySet()) {
                if (entry.getKey() == null) {
                    mapBlockBuilder.closeEntry();
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
                }
                this.keyWriter.write((BlockBuilder)blockBuilder, entry.getKey());
                this.valueWriter.write((BlockBuilder)blockBuilder, entry.getValue());
            }
            try {
                mapBlockBuilder.closeEntryStrict(this.mapType.getKeyBlockEquals(), this.mapType.getKeyBlockHashCode());
            }
            catch (DuplicateMapKeyException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
            }
            return this.mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
        }
    }

    public static class ListObjectEncoder
    implements ObjectEncoder {
        private final ListObjectInspector listInspector;
        private final Type elementType;
        private final BlockObjectWriter writer;

        public static ListObjectEncoder create(Type type, ObjectInspector inspector) {
            Preconditions.checkArgument((inspector instanceof ListObjectInspector && type instanceof ArrayType ? 1 : 0) != 0);
            Type elementType = ((ArrayType)type).getElementType();
            ListObjectInspector listInspector = (ListObjectInspector)inspector;
            ObjectEncoder elementEncoder = ObjectEncoders.createEncoder(elementType, listInspector.getListElementObjectInspector());
            return new ListObjectEncoder(listInspector, elementType, elementEncoder);
        }

        private ListObjectEncoder(ListObjectInspector listInspector, Type elementType, ObjectEncoder elementEncoder) {
            this.listInspector = Objects.requireNonNull(listInspector, "listInspector is null");
            this.elementType = Objects.requireNonNull(elementType, "elementType is null");
            this.writer = new SimpleBlockObjectWriter(elementEncoder, elementType);
        }

        @Override
        public Object encode(Object o) {
            if (o == null) {
                return null;
            }
            int length = this.listInspector.getListLength(o);
            BlockBuilder blockBuilder = this.elementType.createBlockBuilder(null, length);
            for (int i = 0; i < length; ++i) {
                this.writer.write(blockBuilder, this.listInspector.getListElement(o, i));
            }
            return blockBuilder.build();
        }
    }
}

