/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.grpc;

import com.facebook.presto.functionNamespace.execution.NoopSqlFunctionExecutor;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutionModule;
import com.facebook.presto.grpc.GrpcSqlFunctionExecutionConfig;
import com.facebook.presto.grpc.GrpcSqlFunctionExecutor;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionExecutor;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Map;

public class GrpcSqlFunctionExecutionModule
extends SqlFunctionExecutionModule {
    protected void setup(Binder binder) {
        ImmutableMap.Builder grpcUdfConfigBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.supportedLanguages.entrySet()) {
            String languageName = (String)entry.getKey();
            RoutineCharacteristics.Language language = new RoutineCharacteristics.Language(languageName);
            FunctionImplementationType implementationType = (FunctionImplementationType)entry.getValue();
            if (!implementationType.equals((Object)FunctionImplementationType.GRPC)) continue;
            grpcUdfConfigBuilder.put((Object)language, (Object)((GrpcSqlFunctionExecutionConfig)this.buildConfigObject(GrpcSqlFunctionExecutionConfig.class, languageName)));
        }
        ImmutableMap grpcUdfConfigs = grpcUdfConfigBuilder.build();
        if (grpcUdfConfigs.isEmpty()) {
            binder.bind(SqlFunctionExecutor.class).to(NoopSqlFunctionExecutor.class).in(Scopes.SINGLETON);
            return;
        }
        binder.bind(SqlFunctionExecutor.class).to(GrpcSqlFunctionExecutor.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<Map<RoutineCharacteristics.Language, GrpcSqlFunctionExecutionConfig>>(){}).toInstance((Object)grpcUdfConfigs);
    }
}

