/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.google.sheets;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.google.sheets.SheetsClient;
import com.facebook.presto.google.sheets.SheetsConfig;
import com.facebook.presto.google.sheets.SheetsConnector;
import com.facebook.presto.google.sheets.SheetsMetadata;
import com.facebook.presto.google.sheets.SheetsRecordSetProvider;
import com.facebook.presto.google.sheets.SheetsSplitManager;
import com.facebook.presto.google.sheets.SheetsTable;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import jakarta.inject.Inject;
import java.util.Objects;

public class SheetsModule
implements Module {
    private final TypeManager typeManager;

    public SheetsModule(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(SheetsConnector.class).in(Scopes.SINGLETON);
        binder.bind(SheetsMetadata.class).in(Scopes.SINGLETON);
        binder.bind(SheetsClient.class).in(Scopes.SINGLETON);
        binder.bind(SheetsSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(SheetsRecordSetProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(SheetsConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(SheetsTable.class));
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
        }
    }
}

