/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.google.sheets;

import com.facebook.presto.google.sheets.SheetsClient;
import com.facebook.presto.google.sheets.SheetsSplit;
import com.facebook.presto.google.sheets.SheetsTable;
import com.facebook.presto.google.sheets.SheetsTableHandle;
import com.facebook.presto.google.sheets.SheetsTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SheetsSplitManager
implements ConnectorSplitManager {
    private final SheetsClient sheetsClient;

    @Inject
    public SheetsSplitManager(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        SheetsTableLayoutHandle layoutHandle = (SheetsTableLayoutHandle)layout;
        SheetsTableHandle tableHandle = layoutHandle.getTable();
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableHandle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableHandle.toSchemaTableName());
        }
        ArrayList<SheetsSplit> splits = new ArrayList<SheetsSplit>();
        splits.add(new SheetsSplit(tableHandle.getSchemaName(), tableHandle.getTableName(), table.get().getValues()));
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }
}

