/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.google.sheets;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.google.sheets.SheetsColumnHandle;
import com.facebook.presto.google.sheets.SheetsRecordCursor;
import com.facebook.presto.google.sheets.SheetsSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SheetsRecordSet
implements RecordSet {
    private final List<SheetsColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final List<List<Object>> values;

    public SheetsRecordSet(SheetsSplit split, List<SheetsColumnHandle> columnHandles) {
        Objects.requireNonNull(split, "split is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.values = split.getValues();
        this.columnTypes = columnHandles.stream().map(SheetsColumnHandle::getColumnType).collect(Collectors.toList());
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new SheetsRecordCursor(this.columnHandles, this.values);
    }
}

