/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial.rtree;

import com.facebook.presto.geospatial.Rectangle;
import java.util.Objects;

public class HilbertIndex {
    private static final int HILBERT_BITS = 16;
    private static final double HILBERT_MAX = 65535.0;
    private final Rectangle rectangle;
    private final double xScale;
    private final double yScale;

    public HilbertIndex(Rectangle rectangle) {
        this.rectangle = Objects.requireNonNull(rectangle, "rectangle is null");
        this.xScale = rectangle.getXMax() == rectangle.getXMin() ? 0.0 : 65535.0 / (rectangle.getXMax() - rectangle.getXMin());
        this.yScale = rectangle.getYMax() == rectangle.getYMin() ? 0.0 : 65535.0 / (rectangle.getYMax() - rectangle.getYMin());
    }

    public long indexOf(double x, double y) {
        if (!this.rectangle.contains(x, y)) {
            return Long.MAX_VALUE;
        }
        int xInt = (int)(this.xScale * (x - this.rectangle.getXMin()));
        int yInt = (int)(this.yScale * (y - this.rectangle.getYMin()));
        return this.discreteIndexOf(xInt, yInt);
    }

    private long discreteIndexOf(int x, int y) {
        int a = x ^ y;
        int b = 0xFFFF ^ a;
        int c = 0xFFFF ^ (x | y);
        int d = x & (y ^ 0xFFFF);
        int e = a | b >>> 1;
        int f = a >>> 1 ^ a;
        int g = c >>> 1 ^ b & d >>> 1 ^ c;
        int h = a & c >>> 1 ^ d >>> 1 ^ d;
        a = e;
        b = f;
        c = g;
        d = h;
        e = a & a >>> 2 ^ b & b >>> 2;
        f = a & b >>> 2 ^ b & (a ^ b) >>> 2;
        g ^= a & c >>> 2 ^ b & d >>> 2;
        h ^= b & c >>> 2 ^ (a ^ b) & d >>> 2;
        a = e;
        b = f;
        c = g;
        d = h;
        e = a & a >>> 4 ^ b & b >>> 4;
        f = a & b >>> 4 ^ b & (a ^ b) >>> 4;
        g ^= a & c >>> 4 ^ b & d >>> 4;
        h ^= b & c >>> 4 ^ (a ^ b) & d >>> 4;
        a = e;
        b = f;
        c = g;
        d = h;
        g ^= a & c >>> 8 ^ b & d >>> 8;
        h ^= b & c >>> 8 ^ (a ^ b) & d >>> 8;
        a = g ^ g >>> 1;
        b = h ^ h >>> 1;
        int i0 = x ^ y;
        int i1 = b | 0xFFFF ^ (i0 | a);
        i0 = (i0 | i0 << 8) & 0xFF00FF;
        i0 = (i0 | i0 << 4) & 0xF0F0F0F;
        i0 = (i0 | i0 << 2) & 0x33333333;
        i0 = (i0 | i0 << 1) & 0x55555555;
        i1 = (i1 | i1 << 8) & 0xFF00FF;
        i1 = (i1 | i1 << 4) & 0xF0F0F0F;
        i1 = (i1 | i1 << 2) & 0x33333333;
        i1 = (i1 | i1 << 1) & 0x55555555;
        return (long)(i1 << 1 | i0) << 32 >>> 32;
    }
}

