/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import com.facebook.presto.geospatial.Rectangle;
import java.util.HashSet;

public final class GeometryUtils {
    private GeometryUtils() {
    }

    private static double translateFromAVNaN(double n) {
        return n < -1.0E38 ? Double.NaN : n;
    }

    public static double translateToAVNaN(double n) {
        return Double.isNaN(n) ? -1.7976931348623157E308 : n;
    }

    public static boolean isEsriNaN(double d) {
        return Double.isNaN(d) || Double.isNaN(GeometryUtils.translateFromAVNaN(d));
    }

    public static int getPointCount(OGCGeometry ogcGeometry) {
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        int points = 0;
        Geometry geometry;
        while ((geometry = cursor.next()) != null) {
            if (geometry.isEmpty()) continue;
            if (geometry instanceof Point) {
                ++points;
                continue;
            }
            points += ((MultiVertexGeometry)geometry).getPointCount();
        }
        return points;
    }

    public static Envelope getEnvelope(OGCGeometry ogcGeometry) {
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        Envelope overallEnvelope = new Envelope();
        Geometry geometry;
        while ((geometry = cursor.next()) != null) {
            Envelope envelope = new Envelope();
            geometry.queryEnvelope(envelope);
            overallEnvelope.merge(envelope);
        }
        return overallEnvelope;
    }

    public static Rectangle getExtent(OGCGeometry ogcGeometry) {
        return GeometryUtils.getExtent(ogcGeometry, 0.0);
    }

    public static Rectangle getExtent(OGCGeometry ogcGeometry, double radius) {
        Envelope envelope = new Envelope();
        ogcGeometry.getEsriGeometry().queryEnvelope(envelope);
        return new Rectangle(envelope.getXMin() - radius, envelope.getYMin() - radius, envelope.getXMax() + radius, envelope.getYMax() + radius);
    }

    public static org.locationtech.jts.geom.Envelope getJtsEnvelope(OGCGeometry ogcGeometry, double radius) {
        Envelope esriEnvelope = GeometryUtils.getEnvelope(ogcGeometry);
        if (esriEnvelope.isEmpty()) {
            return new org.locationtech.jts.geom.Envelope();
        }
        return new org.locationtech.jts.geom.Envelope(esriEnvelope.getXMin() - radius, esriEnvelope.getXMax() + radius, esriEnvelope.getYMin() - radius, esriEnvelope.getYMax() + radius);
    }

    public static org.locationtech.jts.geom.Envelope getJtsEnvelope(OGCGeometry ogcGeometry) {
        return GeometryUtils.getJtsEnvelope(ogcGeometry, 0.0);
    }

    public static boolean disjoint(Envelope envelope, OGCGeometry ogcGeometry) {
        Geometry geometry;
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        do {
            if ((geometry = cursor.next()) != null) continue;
            return true;
        } while (GeometryEngine.disjoint((Geometry)geometry, (Geometry)envelope, null));
        return false;
    }

    public static boolean contains(OGCGeometry ogcGeometry, Envelope envelope) {
        Geometry geometry;
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        do {
            if ((geometry = cursor.next()) != null) continue;
            return false;
        } while (!GeometryEngine.contains((Geometry)geometry, (Geometry)envelope, null));
        return true;
    }

    public static boolean isPointOrRectangle(OGCGeometry ogcGeometry, Envelope envelope) {
        if (ogcGeometry instanceof OGCPoint) {
            return true;
        }
        if (!(ogcGeometry instanceof OGCPolygon)) {
            return false;
        }
        Polygon polygon = (Polygon)ogcGeometry.getEsriGeometry();
        if (polygon.getPathCount() > 1) {
            return false;
        }
        if (polygon.getPointCount() != 4) {
            return false;
        }
        HashSet<Point> corners = new HashSet<Point>();
        corners.add(new Point(envelope.getXMin(), envelope.getYMin()));
        corners.add(new Point(envelope.getXMin(), envelope.getYMax()));
        corners.add(new Point(envelope.getXMax(), envelope.getYMin()));
        corners.add(new Point(envelope.getXMax(), envelope.getYMax()));
        for (int i = 0; i < 4; ++i) {
            Point point = polygon.getPoint(i);
            if (corners.contains(point)) continue;
            return false;
        }
        return true;
    }
}

