/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.FunctionExtractor;
import com.facebook.presto.server.PluginClassLoader;
import com.facebook.presto.server.PluginDiscovery;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.spi.CoordinatorPlugin;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sonatype.aether.artifact.Artifact;

@ThreadSafe
public class FunctionPluginManager {
    private static final ImmutableList<String> SPI_PACKAGES = ImmutableList.builder().add((Object)"com.facebook.presto.spi.").add((Object)"com.fasterxml.jackson.annotation.").add((Object)"com.fasterxml.jackson.module.afterburner.").add((Object)"io.airlift.slice.").add((Object)"com.facebook.airlift.units.").add((Object)"org.openjdk.jol.").add((Object)"com.facebook.presto.common").add((Object)"com.facebook.drift.annotations.").add((Object)"com.facebook.drift.TException").add((Object)"com.facebook.drift.TApplicationException").build();
    private static final String PLUGIN_SERVICES_FILE = "META-INF/services/" + Plugin.class.getName();
    private static final Logger log = Logger.get(FunctionPluginManager.class);
    private final ArtifactResolver resolver;
    private final File installedPluginsDir;
    private final List<String> plugins;
    private final AtomicBoolean pluginsLoading = new AtomicBoolean();
    private final AtomicBoolean pluginsLoaded = new AtomicBoolean();
    private final FunctionAndTypeManager functionAndTypeManager;

    @Inject
    public FunctionPluginManager(PluginManagerConfig config, FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.functionAndTypeManager = functionAndTypeManager;
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.plugins = config.getPlugins() == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)config.getPlugins());
        this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
    }

    public void loadPlugins() throws Exception {
        if (!this.pluginsLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : FunctionPluginManager.listFiles(this.installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            this.loadPlugin(file.getAbsolutePath());
        }
        for (String plugin : this.plugins) {
            this.loadPlugin(plugin);
        }
        this.pluginsLoaded.set(true);
    }

    private void loadPlugin(String plugin) throws Exception {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        URLClassLoader pluginClassLoader = this.buildClassLoader(plugin);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            this.loadPlugin(pluginClassLoader, Plugin.class);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    private void loadPlugin(URLClassLoader pluginClassLoader, Class<?> clazz) {
        ServiceLoader<?> serviceLoader = ServiceLoader.load(clazz, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        if (plugins.isEmpty()) {
            log.warn("No service providers of type %s", new Object[]{clazz.getName()});
        }
        for (Object plugin : plugins) {
            log.info("Installing %s", new Object[]{plugin.getClass().getName()});
            if (plugin instanceof Plugin) {
                this.installPlugin((Plugin)plugin);
                continue;
            }
            log.warn("Unknown plugin type: %s", new Object[]{plugin.getClass().getName()});
        }
    }

    public void installPlugin(Plugin plugin) {
        for (Class functionClass : plugin.getFunctions()) {
            log.info("Registering functions from %s", new Object[]{functionClass.getName()});
            this.functionAndTypeManager.registerBuiltInFunctions(FunctionExtractor.extractFunctions((Class)functionClass));
        }
    }

    private URLClassLoader buildClassLoader(String plugin) throws Exception {
        File file = new File(plugin);
        if (file.isFile() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return this.buildClassLoaderFromPom(file);
        }
        if (file.isDirectory()) {
            return this.buildClassLoaderFromDirectory(file);
        }
        return this.buildClassLoaderFromCoordinates(plugin);
    }

    private URLClassLoader buildClassLoaderFromPom(File pomFile) throws Exception {
        List artifacts = this.resolver.resolvePom(pomFile);
        URLClassLoader classLoader = this.createClassLoader(artifacts, pomFile.getPath());
        Artifact artifact = (Artifact)artifacts.get(0);
        this.processPlugins(artifact, classLoader, PLUGIN_SERVICES_FILE, CoordinatorPlugin.class.getName());
        return classLoader;
    }

    private URLClassLoader buildClassLoaderFromDirectory(File dir) throws Exception {
        log.debug("Classpath for %s:", new Object[]{dir.getName()});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : FunctionPluginManager.listFiles(dir)) {
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader buildClassLoaderFromCoordinates(String coordinates) throws Exception {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        List artifacts = this.resolver.resolveArtifacts(new Artifact[]{rootArtifact});
        return this.createClassLoader(artifacts, rootArtifact.toString());
    }

    private URLClassLoader createClassLoader(List<Artifact> artifacts, String name) throws IOException {
        log.debug("Classpath for %s:", new Object[]{name});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : FunctionPluginManager.sortedArtifacts(artifacts)) {
            if (artifact.getFile() == null) {
                throw new RuntimeException("Could not resolve artifact: " + String.valueOf(artifact));
            }
            File file = artifact.getFile().getCanonicalFile();
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader createClassLoader(List<URL> urls) {
        ClassLoader parent = this.getClass().getClassLoader();
        return new PluginClassLoader(urls, parent, SPI_PACKAGES);
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            Arrays.sort(files);
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static List<Artifact> sortedArtifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts);
        Collections.sort(list, Ordering.natural().nullsLast().onResultOf(Artifact::getFile));
        return list;
    }

    private void processPlugins(Artifact artifact, ClassLoader classLoader, String servicesFile, String className) throws IOException {
        Set plugins = PluginDiscovery.discoverPlugins((Artifact)artifact, (ClassLoader)classLoader, (String)servicesFile, (String)className);
        if (!plugins.isEmpty()) {
            PluginDiscovery.writePluginServices((Iterable)plugins, (File)artifact.getFile(), (String)servicesFile);
        }
    }
}

