/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.rest;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutionModule;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.execution.SqlFunctionLanguageConfig;
import com.facebook.presto.functionNamespace.rest.RestBasedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.rest.RestSqlFunctionExecutionModule;
import com.facebook.presto.functionNamespace.rest.RestSqlFunctionExecutor;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Objects;

public class RestSqlFunctionExecutorsModule
extends AbstractConfigurationAwareModule {
    private final SqlFunctionExecutionModule sqlFunctionExecutorModule;

    public RestSqlFunctionExecutorsModule() {
        this(new RestSqlFunctionExecutionModule());
    }

    public RestSqlFunctionExecutorsModule(SqlFunctionExecutionModule sqlFunctionExecutorModule) {
        this.sqlFunctionExecutorModule = Objects.requireNonNull(sqlFunctionExecutorModule, "sqlFunctionExecutorModule is null");
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(RestBasedFunctionNamespaceManagerConfig.class);
        binder.bind(RestSqlFunctionExecutor.class).in(Scopes.SINGLETON);
        ImmutableMap.Builder languageImplementationTypeMap = ImmutableMap.builder();
        ImmutableMap.Builder supportedLanguages = ImmutableMap.builder();
        SqlInvokedFunctionNamespaceManagerConfig config = (SqlInvokedFunctionNamespaceManagerConfig)this.buildConfigObject(SqlInvokedFunctionNamespaceManagerConfig.class);
        for (String languageName : config.getSupportedFunctionLanguages()) {
            RoutineCharacteristics.Language language = new RoutineCharacteristics.Language(languageName);
            FunctionImplementationType implementationType = ((SqlFunctionLanguageConfig)this.buildConfigObject(SqlFunctionLanguageConfig.class, languageName)).setFunctionImplementationType("REST").getFunctionImplementationType();
            languageImplementationTypeMap.put((Object)language, (Object)implementationType);
            supportedLanguages.put((Object)languageName, (Object)implementationType);
        }
        this.sqlFunctionExecutorModule.setSupportedLanguages((Map)supportedLanguages.build());
        this.install((Module)this.sqlFunctionExecutorModule);
        binder.bind(SqlFunctionExecutors.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<Map<RoutineCharacteristics.Language, FunctionImplementationType>>(){}).toInstance((Object)languageImplementationTypeMap.build());
    }
}

