/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.json;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.functionNamespace.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.ServingCatalog;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.json.FunctionDefinitionProvider;
import com.facebook.presto.functionNamespace.json.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.json.JsonFileBasedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.json.UdfFunctionSignatureMap;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunctionImplementation;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

public class JsonFileBasedFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private static final Logger log = Logger.get(JsonFileBasedFunctionNamespaceManager.class);
    private final Map<SqlFunctionId, SqlInvokedFunction> latestFunctions = new ConcurrentHashMap<SqlFunctionId, SqlInvokedFunction>();
    private final Map<QualifiedObjectName, UserDefinedType> userDefinedTypes = new ConcurrentHashMap<QualifiedObjectName, UserDefinedType>();
    private final JsonFileBasedFunctionNamespaceManagerConfig managerConfig;
    private final FunctionDefinitionProvider functionDefinitionProvider;
    private final Map<SqlFunctionHandle, AggregationFunctionImplementation> aggregationImplementationByHandle = new ConcurrentHashMap<SqlFunctionHandle, AggregationFunctionImplementation>();

    @Inject
    public JsonFileBasedFunctionNamespaceManager(@ServingCatalog String catalogName, SqlFunctionExecutors sqlFunctionExecutors, SqlInvokedFunctionNamespaceManagerConfig config, JsonFileBasedFunctionNamespaceManagerConfig managerConfig, FunctionDefinitionProvider functionDefinitionProvider) {
        super(catalogName, sqlFunctionExecutors, config);
        this.managerConfig = Objects.requireNonNull(managerConfig, "managerConfig is null");
        this.functionDefinitionProvider = Objects.requireNonNull(functionDefinitionProvider, "functionDefinitionProvider is null");
        this.bootstrapNamespaceFromFile();
    }

    public final AggregationFunctionImplementation getAggregateFunctionImplementation(FunctionHandle functionHandle, TypeManager typeManager) {
        this.checkCatalog(functionHandle);
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlFunctionHandle), (String)"Unsupported FunctionHandle type '%s'", (Object)functionHandle.getClass().getSimpleName());
        SqlFunctionHandle sqlFunctionHandle = (SqlFunctionHandle)functionHandle;
        if (!this.aggregationImplementationByHandle.containsKey(sqlFunctionHandle)) {
            SqlFunctionId functionId = sqlFunctionHandle.getFunctionId();
            if (!this.latestFunctions.containsKey(functionId)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Function '%s' is missing from cache", functionId.getId()));
            }
            this.aggregationImplementationByHandle.put(sqlFunctionHandle, this.sqlInvokedFunctionToAggregationImplementation(this.latestFunctions.get(functionId), typeManager));
        }
        return this.aggregationImplementationByHandle.get(sqlFunctionHandle);
    }

    private static SqlInvokedFunction copyFunction(SqlInvokedFunction function) {
        return new SqlInvokedFunction(function.getSignature().getName(), function.getParameters(), function.getSignature().getReturnType(), function.getDescription(), function.getRoutineCharacteristics(), function.getBody(), function.getVersion(), function.getSignature().getKind(), function.getAggregationMetadata());
    }

    private void bootstrapNamespaceFromFile() {
        UdfFunctionSignatureMap udfFunctionSignatureMap = this.functionDefinitionProvider.getUdfDefinition(this.managerConfig.getFunctionDefinitionFile());
        if (udfFunctionSignatureMap == null || udfFunctionSignatureMap.isEmpty()) {
            return;
        }
        this.populateNameSpaceManager(udfFunctionSignatureMap);
    }

    private void populateNameSpaceManager(UdfFunctionSignatureMap udfFunctionSignatureMap) {
        Map<String, List<JsonBasedUdfFunctionMetadata>> udfSignatureMap = udfFunctionSignatureMap.getUDFSignatureMap();
        udfSignatureMap.forEach((name, metaInfoList) -> {
            List functions = (List)metaInfoList.stream().map(metaInfo -> this.createSqlInvokedFunction((String)name, (JsonBasedUdfFunctionMetadata)metaInfo)).collect(ImmutableList.toImmutableList());
            functions.forEach(function -> this.createFunction((SqlInvokedFunction)function, false));
        });
    }

    private SqlInvokedFunction createSqlInvokedFunction(String functionName, JsonBasedUdfFunctionMetadata jsonBasedUdfFunctionMetaData) {
        Preconditions.checkState((boolean)jsonBasedUdfFunctionMetaData.getRoutineCharacteristics().getLanguage().equals((Object)RoutineCharacteristics.Language.CPP), (Object)"JsonFileBasedFunctionNamespaceManager only supports CPP UDF");
        QualifiedObjectName qualifiedFunctionName = QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName(this.getCatalogName(), jsonBasedUdfFunctionMetaData.getSchema()), (String)functionName);
        List<String> parameterNameList = jsonBasedUdfFunctionMetaData.getParamNames();
        List<TypeSignature> parameterTypeList = jsonBasedUdfFunctionMetaData.getParamTypes();
        ImmutableList.Builder parameterBuilder = ImmutableList.builder();
        for (int i = 0; i < parameterNameList.size(); ++i) {
            parameterBuilder.add((Object)new Parameter(parameterNameList.get(i), parameterTypeList.get(i)));
        }
        return new SqlInvokedFunction(qualifiedFunctionName, (List)parameterBuilder.build(), jsonBasedUdfFunctionMetaData.getOutputType(), jsonBasedUdfFunctionMetaData.getDocString(), jsonBasedUdfFunctionMetaData.getRoutineCharacteristics(), "", FunctionVersion.notVersioned(), jsonBasedUdfFunctionMetaData.getFunctionKind(), jsonBasedUdfFunctionMetaData.getAggregateMetadata());
    }

    @Override
    protected Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedObjectName functionName) {
        return (Collection)this.latestFunctions.values().stream().filter(function -> function.getSignature().getName().equals((Object)functionName)).map(JsonFileBasedFunctionNamespaceManager::copyFunction).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected UserDefinedType fetchUserDefinedTypeDirect(QualifiedObjectName typeName) {
        return this.userDefinedTypes.get(typeName);
    }

    @Override
    protected FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle functionHandle) {
        return (FunctionMetadata)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(this::sqlInvokedFunctionToMetadata).collect(MoreCollectors.onlyElement());
    }

    @Override
    protected ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle functionHandle) {
        return (ScalarFunctionImplementation)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(this::sqlInvokedFunctionToImplementation).collect(MoreCollectors.onlyElement());
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        this.checkFunctionLanguageSupported(function);
        SqlFunctionId functionId = function.getFunctionId();
        if (!replace && this.latestFunctions.containsKey(function.getFunctionId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Function '%s' already exists", functionId.getId()));
        }
        SqlInvokedFunction replacedFunction = this.latestFunctions.get(functionId);
        long version = 1L;
        if (replacedFunction != null) {
            version = Long.parseLong(replacedFunction.getRequiredVersion()) + 1L;
        }
        this.latestFunctions.put(functionId, function.withVersion(String.valueOf(version)));
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Alter Function is not supported in JsonFileBasedFunctionNamespaceManager");
    }

    public void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Drop Function is not supported in JsonFileBasedFunctionNamespaceManager");
    }

    public Collection<SqlInvokedFunction> listFunctions(Optional<String> likePattern, Optional<String> escape) {
        return this.latestFunctions.values();
    }

    public void addUserDefinedType(UserDefinedType userDefinedType) {
        QualifiedObjectName name = userDefinedType.getUserDefinedTypeName();
        Preconditions.checkArgument((!this.userDefinedTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type %s already registered", (Object)name);
        this.userDefinedTypes.put(name, userDefinedType);
    }
}

