/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.function.SqlFunctionResult;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.RemoteScalarFunctionImplementation;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.SqlFunctionExecutor;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class SqlFunctionExecutors {
    private final Map<RoutineCharacteristics.Language, FunctionImplementationType> supportedLanguages;
    private final SqlFunctionExecutor sqlFunctionExecutor;

    @Inject
    public SqlFunctionExecutors(Map<RoutineCharacteristics.Language, FunctionImplementationType> supportedLanguages, SqlFunctionExecutor sqlFunctionExecutor) {
        this.supportedLanguages = Objects.requireNonNull(supportedLanguages, "supportedLanguages is null");
        this.sqlFunctionExecutor = Objects.requireNonNull(sqlFunctionExecutor, "sqlFunctionExecutor is null");
    }

    public void setBlockEncodingSerde(BlockEncodingSerde blockEncodingSerde) {
        this.sqlFunctionExecutor.setBlockEncodingSerde(blockEncodingSerde);
    }

    public Set<RoutineCharacteristics.Language> getSupportedLanguages() {
        return this.supportedLanguages.keySet();
    }

    public FunctionImplementationType getFunctionImplementationType(RoutineCharacteristics.Language language) {
        return this.supportedLanguages.get(language);
    }

    public CompletableFuture<SqlFunctionResult> executeFunction(String source, ScalarFunctionImplementation functionImplementation, Page input, List<Integer> channels, List<Type> argumentTypes, Type returnType) {
        Preconditions.checkArgument((boolean)(functionImplementation instanceof RemoteScalarFunctionImplementation), (Object)String.format("Only support RemoteScalarFunctionImplementation, got %s", functionImplementation.getClass()));
        FunctionImplementationType implementationType = ((RemoteScalarFunctionImplementation)functionImplementation).getImplementationType();
        Preconditions.checkState((boolean)this.sqlFunctionExecutor.getImplementationType().equals((Object)implementationType), (Object)String.format("%s SQL function executor is not setup", implementationType));
        return this.sqlFunctionExecutor.executeFunction(source, (RemoteScalarFunctionImplementation)functionImplementation, input, channels, argumentTypes, returnType);
    }
}

