/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.execution.thrift;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.drift.TException;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.function.SqlFunctionResult;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.functionNamespace.execution.ExceptionUtils;
import com.facebook.presto.functionNamespace.execution.thrift.ThriftSqlFunctionExecutionConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.ThriftScalarFunctionImplementation;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.udf.PrestoThriftPage;
import com.facebook.presto.thrift.api.udf.ThriftFunctionHandle;
import com.facebook.presto.thrift.api.udf.ThriftUdfPage;
import com.facebook.presto.thrift.api.udf.ThriftUdfPageFormat;
import com.facebook.presto.thrift.api.udf.ThriftUdfRequest;
import com.facebook.presto.thrift.api.udf.ThriftUdfResult;
import com.facebook.presto.thrift.api.udf.ThriftUdfService;
import com.facebook.presto.thrift.api.udf.ThriftUdfServiceException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class ThriftSqlFunctionExecutor {
    private static final int DEFAULT_RETRY_ATTEMPTS = 3;
    private final DriftClient<ThriftUdfService> thriftUdfClient;
    private final Map<RoutineCharacteristics.Language, ThriftSqlFunctionExecutionConfig> executionConfigs;
    private BlockEncodingSerde blockEncodingSerde;

    @Inject
    public ThriftSqlFunctionExecutor(DriftClient<ThriftUdfService> thriftUdfClient, Map<RoutineCharacteristics.Language, ThriftSqlFunctionExecutionConfig> executionConfigs) {
        this.thriftUdfClient = Objects.requireNonNull(thriftUdfClient, "thriftUdfClient is null");
        this.executionConfigs = Objects.requireNonNull(executionConfigs, "executionConfigs is null");
    }

    public void setBlockEncodingSerde(BlockEncodingSerde blockEncodingSerde) {
        Preconditions.checkState((this.blockEncodingSerde == null ? 1 : 0) != 0, (Object)"blockEncodingSerde already set");
        Preconditions.checkArgument((blockEncodingSerde != null ? 1 : 0) != 0, (Object)"blockEncodingSerde is null");
        this.blockEncodingSerde = blockEncodingSerde;
    }

    public CompletableFuture<SqlFunctionResult> executeFunction(String source, ThriftScalarFunctionImplementation functionImplementation, Page input, List<Integer> channels, List<Type> argumentTypes, Type returnType) {
        ThriftUdfPage page = this.buildThriftPage(functionImplementation, input, channels, argumentTypes);
        SqlFunctionHandle functionHandle = functionImplementation.getFunctionHandle();
        SqlFunctionId functionId = functionHandle.getFunctionId();
        ThriftFunctionHandle thriftFunctionHandle = new ThriftFunctionHandle(functionId.getFunctionName().toString(), (List)functionId.getArgumentTypes().stream().map(TypeSignature::toString).collect(ImmutableList.toImmutableList()), returnType.toString(), functionHandle.getVersion());
        ThriftUdfService thriftUdfService = (ThriftUdfService)this.thriftUdfClient.get(Optional.of(functionImplementation.getLanguage().getLanguage()));
        return ThriftSqlFunctionExecutor.invokeUdfWithRetry(thriftUdfService, new ThriftUdfRequest(source, thriftFunctionHandle, page)).thenApply(thriftResult -> this.toSqlFunctionResult((ThriftUdfResult)thriftResult, returnType));
    }

    private static CompletableFuture<ThriftUdfResult> invokeUdf(ThriftUdfService thriftUdfService, ThriftUdfRequest request) {
        try {
            return MoreFutures.toCompletableFuture((ListenableFuture)thriftUdfService.invokeUdf(request));
        }
        catch (TException | ThriftUdfServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private static CompletableFuture<ThriftUdfResult> invokeUdfWithRetry(ThriftUdfService thriftUdfService, ThriftUdfRequest request) {
        CompletionStage<Object> resultFuture = ThriftSqlFunctionExecutor.invokeUdf(thriftUdfService, request);
        for (int i = 0; i < 3; ++i) {
            resultFuture = ((CompletableFuture)((CompletableFuture)resultFuture.thenApply(CompletableFuture::completedFuture)).exceptionally(t -> {
                Throwable e = t.getCause();
                if (e instanceof PrestoException) {
                    throw (PrestoException)e;
                }
                if (e instanceof ThriftUdfServiceException && ((ThriftUdfServiceException)e).isRetryable()) {
                    return ThriftSqlFunctionExecutor.invokeUdf(thriftUdfService, request);
                }
                PrestoException prestoException = e instanceof ThriftUdfServiceException ? ExceptionUtils.toPrestoException((ThriftUdfServiceException)e) : new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e);
                throw prestoException;
            })).thenCompose(Function.identity());
        }
        return resultFuture;
    }

    private ThriftUdfPage buildThriftPage(ThriftScalarFunctionImplementation functionImplementation, Page input, List<Integer> channels, List<Type> argumentTypes) {
        ThriftUdfPageFormat pageFormat = this.executionConfigs.get(functionImplementation.getLanguage()).getThriftPageFormat();
        Block[] blocks = new Block[channels.size()];
        for (int i = 0; i < channels.size(); ++i) {
            blocks[i] = input.getBlock(channels.get(i).intValue());
        }
        switch (pageFormat) {
            case PRESTO_THRIFT: {
                ImmutableList.Builder thriftBlocks = ImmutableList.builder();
                for (int i = 0; i < blocks.length; ++i) {
                    thriftBlocks.add((Object)PrestoThriftBlock.fromBlock((Block)blocks[i], (Type)argumentTypes.get(i)));
                }
                return ThriftUdfPage.thriftPage((PrestoThriftPage)new PrestoThriftPage((List)thriftBlocks.build(), input.getPositionCount()));
            }
            case PRESTO_SERIALIZED: {
                Preconditions.checkState((this.blockEncodingSerde != null ? 1 : 0) != 0, (Object)"blockEncodingSerde not set");
                PagesSerde pagesSerde = new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), Optional.empty());
                return ThriftUdfPage.prestoPage((SerializedPage)pagesSerde.serialize(Page.wrapBlocksWithoutCopy((int)input.getPositionCount(), (Block[])blocks)));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown page format: %s", pageFormat));
    }

    private SqlFunctionResult toSqlFunctionResult(ThriftUdfResult result, Type returnType) {
        ThriftUdfPage page = result.getResult();
        switch (page.getPageFormat()) {
            case PRESTO_THRIFT: {
                return new SqlFunctionResult(((PrestoThriftBlock)Iterables.getOnlyElement((Iterable)page.getThriftPage().getThriftBlocks())).toBlock(returnType), result.getUdfStats().getTotalCpuTimeMs());
            }
            case PRESTO_SERIALIZED: {
                Preconditions.checkState((this.blockEncodingSerde != null ? 1 : 0) != 0, (Object)"blockEncodingSerde not set");
                PagesSerde pagesSerde = new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), Optional.empty());
                return new SqlFunctionResult(pagesSerde.deserialize(page.getPrestoPage().toSerializedPage()).getBlock(0), result.getUdfStats().getTotalCpuTimeMs());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown page format: %s", page.getPageFormat()));
    }
}

