/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.functionNamespace.mysql.FunctionNamespaceDao;
import com.facebook.presto.functionNamespace.mysql.FunctionNamespacesTableCustomizerFactory;
import com.facebook.presto.functionNamespace.mysql.MySqlConnectionConfig;
import com.facebook.presto.functionNamespace.mysql.MySqlFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.mysql.SqlFunctionsTableCustomizerFactory;
import com.facebook.presto.functionNamespace.mysql.UserDefinedTypesTableCustomizerFactory;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.sql.DriverManager;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class MySqlConnectionModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlConnectionConfig.class);
        String databaseUrl = ((MySqlConnectionConfig)this.buildConfigObject(MySqlConnectionConfig.class)).getDatabaseUrl();
        Jdbi jdbi = MySqlConnectionModule.createJdbi(() -> DriverManager.getConnection(databaseUrl), (MySqlFunctionNamespaceManagerConfig)this.buildConfigObject(MySqlFunctionNamespaceManagerConfig.class));
        binder.bind(Jdbi.class).toInstance((Object)jdbi);
        binder.bind(FunctionNamespaceDao.class).toProvider(FunctionNamespaceDaoProvider.class);
        binder.bind((TypeLiteral)new TypeLiteral<Class<? extends FunctionNamespaceDao>>(){}).toInstance(FunctionNamespaceDao.class);
    }

    public static Jdbi createJdbi(String url, MySqlFunctionNamespaceManagerConfig config) {
        return MySqlConnectionModule.createJdbi(() -> DriverManager.getConnection(url), config);
    }

    public static Jdbi createJdbi(ConnectionFactory connectionFactory, MySqlFunctionNamespaceManagerConfig config) {
        Jdbi jdbi = Jdbi.create((ConnectionFactory)connectionFactory).installPlugin((JdbiPlugin)new SqlObjectPlugin());
        ((FunctionNamespacesTableCustomizerFactory.Config)jdbi.getConfig(FunctionNamespacesTableCustomizerFactory.Config.class)).setTableName(config.getFunctionNamespacesTableName());
        ((SqlFunctionsTableCustomizerFactory.Config)jdbi.getConfig(SqlFunctionsTableCustomizerFactory.Config.class)).setTableName(config.getFunctionsTableName());
        ((UserDefinedTypesTableCustomizerFactory.Config)jdbi.getConfig(UserDefinedTypesTableCustomizerFactory.Config.class)).setTableName(config.getUserDefinedTypesTableName());
        return jdbi;
    }

    public static class FunctionNamespaceDaoProvider
    implements Provider<FunctionNamespaceDao> {
        private Injector injector;

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public FunctionNamespaceDao get() {
            return (FunctionNamespaceDao)((Jdbi)this.injector.getInstance(Jdbi.class)).onDemand(FunctionNamespaceDao.class);
        }
    }
}

