/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.UuidFunctionNamespaceTransactionHandle;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.spi.function.ThriftScalarFunctionImplementation;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractSqlInvokedFunctionNamespaceManager
implements FunctionNamespaceManager<SqlInvokedFunction> {
    private final ConcurrentMap<FunctionNamespaceTransactionHandle, FunctionCollection> transactions = new ConcurrentHashMap<FunctionNamespaceTransactionHandle, FunctionCollection>();
    private final String catalogName;
    private final SqlFunctionExecutors sqlFunctionExecutors;
    private final LoadingCache<QualifiedObjectName, Collection<SqlInvokedFunction>> functions;
    private final LoadingCache<QualifiedObjectName, UserDefinedType> userDefinedTypes;
    private final LoadingCache<SqlFunctionHandle, FunctionMetadata> metadataByHandle;
    private final LoadingCache<SqlFunctionHandle, ScalarFunctionImplementation> implementationByHandle;

    public AbstractSqlInvokedFunctionNamespaceManager(String catalogName, SqlFunctionExecutors sqlFunctionExecutors, SqlInvokedFunctionNamespaceManagerConfig config) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.sqlFunctionExecutors = Objects.requireNonNull(sqlFunctionExecutors, "sqlFunctionExecutors is null");
        Objects.requireNonNull(config, "config is null");
        this.functions = CacheBuilder.newBuilder().expireAfterWrite(config.getFunctionCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<QualifiedObjectName, Collection<SqlInvokedFunction>>(){

            @ParametersAreNonnullByDefault
            public Collection<SqlInvokedFunction> load(QualifiedObjectName functionName) {
                Collection<SqlInvokedFunction> functions = AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionsDirect(functionName);
                for (SqlInvokedFunction function : functions) {
                    AbstractSqlInvokedFunctionNamespaceManager.this.metadataByHandle.put((Object)function.getRequiredFunctionHandle(), (Object)AbstractSqlInvokedFunctionNamespaceManager.this.sqlInvokedFunctionToMetadata(function));
                }
                return functions;
            }
        });
        this.userDefinedTypes = CacheBuilder.newBuilder().expireAfterWrite(config.getTypeCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build(CacheLoader.from(this::fetchUserDefinedTypeDirect));
        this.metadataByHandle = CacheBuilder.newBuilder().expireAfterWrite(config.getFunctionInstanceCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<SqlFunctionHandle, FunctionMetadata>(){

            @ParametersAreNonnullByDefault
            public FunctionMetadata load(SqlFunctionHandle functionHandle) {
                return AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionMetadataDirect(functionHandle);
            }
        });
        this.implementationByHandle = CacheBuilder.newBuilder().expireAfterWrite(config.getFunctionInstanceCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<SqlFunctionHandle, ScalarFunctionImplementation>(){

            public ScalarFunctionImplementation load(SqlFunctionHandle functionHandle) {
                return AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionImplementationDirect(functionHandle);
            }
        });
    }

    protected abstract Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedObjectName var1);

    protected abstract UserDefinedType fetchUserDefinedTypeDirect(QualifiedObjectName var1);

    protected abstract FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle var1);

    protected abstract ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle var1);

    public void setBlockEncodingSerde(BlockEncodingSerde blockEncodingSerde) {
        this.sqlFunctionExecutors.setBlockEncodingSerde(blockEncodingSerde);
    }

    public final FunctionNamespaceTransactionHandle beginTransaction() {
        UuidFunctionNamespaceTransactionHandle transactionHandle = UuidFunctionNamespaceTransactionHandle.create();
        this.transactions.put(transactionHandle, new FunctionCollection());
        return transactionHandle;
    }

    public final void commit(FunctionNamespaceTransactionHandle transactionHandle) {
        this.transactions.remove(transactionHandle);
    }

    public final void abort(FunctionNamespaceTransactionHandle transactionHandle) {
        this.transactions.remove(transactionHandle);
    }

    public final Collection<SqlInvokedFunction> getFunctions(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, QualifiedObjectName functionName) {
        this.checkCatalog(functionName);
        if (transactionHandle.isPresent()) {
            return ((FunctionCollection)this.transactions.get(transactionHandle.get())).loadAndGetFunctionsTransactional(functionName);
        }
        return this.fetchFunctionsDirect(functionName);
    }

    public Optional<UserDefinedType> getUserDefinedType(QualifiedObjectName typeName) {
        try {
            return Optional.of(this.userDefinedTypes.getUnchecked((Object)typeName));
        }
        catch (PrestoException e) {
            if (e.getErrorCode().equals((Object)StandardErrorCode.NOT_FOUND.toErrorCode())) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public final FunctionHandle getFunctionHandle(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, Signature signature) {
        this.checkCatalog(signature.getName());
        SqlFunctionId functionId = new SqlFunctionId(signature.getName(), signature.getArgumentTypes());
        if (transactionHandle.isPresent()) {
            return ((FunctionCollection)this.transactions.get(transactionHandle.get())).getFunctionHandle(functionId);
        }
        FunctionCollection collection = new FunctionCollection();
        collection.loadAndGetFunctionsTransactional(signature.getName());
        return collection.getFunctionHandle(functionId);
    }

    public final FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        this.checkCatalog(functionHandle);
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlFunctionHandle), (String)"Unsupported FunctionHandle type '%s'", (Object)functionHandle.getClass().getSimpleName());
        return (FunctionMetadata)this.metadataByHandle.getUnchecked((Object)((SqlFunctionHandle)functionHandle));
    }

    public final ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        this.checkCatalog(functionHandle);
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlFunctionHandle), (String)"Unsupported FunctionHandle type '%s'", (Object)functionHandle.getClass().getSimpleName());
        return (ScalarFunctionImplementation)this.implementationByHandle.getUnchecked((Object)((SqlFunctionHandle)functionHandle));
    }

    public CompletableFuture<Block> executeFunction(FunctionHandle functionHandle, Page input, List<Integer> channels, TypeManager typeManager) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlFunctionHandle), (Object)String.format("Expect SqlFunctionHandle, got %s", functionHandle.getClass()));
        FunctionMetadata functionMetadata = this.getFunctionMetadata(functionHandle);
        return this.sqlFunctionExecutors.executeFunction(this.getScalarFunctionImplementation(functionHandle), input, channels, (List)functionMetadata.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList()), typeManager.getType(functionMetadata.getReturnType()));
    }

    protected String getCatalogName() {
        return this.catalogName;
    }

    protected void checkCatalog(SqlFunction function) {
        this.checkCatalog(function.getSignature().getName());
    }

    protected void checkCatalog(QualifiedObjectName functionName) {
        this.checkCatalog(functionName.getCatalogSchemaName());
    }

    protected void checkCatalog(FunctionHandle functionHandle) {
        this.checkCatalog(functionHandle.getCatalogSchemaName());
    }

    protected void checkCatalog(CatalogSchemaName functionNamespace) {
        Preconditions.checkArgument((boolean)this.catalogName.equals(functionNamespace.getCatalogName()), (String)"Catalog [%s] is not served by this FunctionNamespaceManager, expected: %s", (Object)functionNamespace.getCatalogName(), (Object)this.catalogName);
    }

    protected void refreshFunctionsCache(QualifiedObjectName functionName) {
        this.functions.refresh((Object)functionName);
    }

    protected void checkFunctionLanguageSupported(SqlInvokedFunction function) {
        if (!this.sqlFunctionExecutors.getSupportedLanguages().contains(function.getRoutineCharacteristics().getLanguage())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Catalog %s does not support functions implemented in language %s", this.catalogName, function.getRoutineCharacteristics().getLanguage()));
        }
    }

    protected FunctionMetadata sqlInvokedFunctionToMetadata(SqlInvokedFunction function) {
        return new FunctionMetadata(function.getSignature().getName(), function.getSignature().getArgumentTypes(), (List)function.getParameters().stream().map(Parameter::getName).collect(ImmutableList.toImmutableList()), function.getSignature().getReturnType(), FunctionKind.SCALAR, function.getRoutineCharacteristics().getLanguage(), this.getFunctionImplementationType(function), function.isDeterministic(), function.isCalledOnNullInput());
    }

    protected FunctionImplementationType getFunctionImplementationType(SqlInvokedFunction function) {
        return this.sqlFunctionExecutors.getFunctionImplementationType(function.getRoutineCharacteristics().getLanguage());
    }

    protected ScalarFunctionImplementation sqlInvokedFunctionToImplementation(SqlInvokedFunction function) {
        FunctionImplementationType implementationType = this.getFunctionImplementationType(function);
        switch (implementationType) {
            case SQL: {
                return new SqlInvokedScalarFunctionImplementation(function.getBody());
            }
            case THRIFT: {
                Preconditions.checkArgument((boolean)function.getFunctionHandle().isPresent(), (Object)"Need functionHandle to get function implementation");
                return new ThriftScalarFunctionImplementation((SqlFunctionHandle)function.getFunctionHandle().get(), function.getRoutineCharacteristics().getLanguage());
            }
            case BUILTIN: {
                throw new IllegalStateException(String.format("SqlInvokedFunction %s has BUILTIN implementation type but %s cannot manage BUILTIN functions", function.getSignature().getName(), this.getClass()));
            }
        }
        throw new IllegalStateException(String.format("Unknown function implementation type: %s", implementationType));
    }

    private Collection<SqlInvokedFunction> fetchFunctions(QualifiedObjectName functionName) {
        return (Collection)this.functions.getUnchecked((Object)functionName);
    }

    private class FunctionCollection {
        @GuardedBy(value="this")
        private final Map<QualifiedObjectName, Collection<SqlInvokedFunction>> functions = new ConcurrentHashMap<QualifiedObjectName, Collection<SqlInvokedFunction>>();
        @GuardedBy(value="this")
        private final Map<SqlFunctionId, SqlFunctionHandle> functionHandles = new ConcurrentHashMap<SqlFunctionId, SqlFunctionHandle>();

        private FunctionCollection() {
        }

        public synchronized Collection<SqlInvokedFunction> loadAndGetFunctionsTransactional(QualifiedObjectName functionName) {
            Collection functions = this.functions.computeIfAbsent(functionName, x$0 -> AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctions(x$0));
            this.functionHandles.putAll((Map)functions.stream().collect(ImmutableMap.toImmutableMap(SqlInvokedFunction::getFunctionId, SqlInvokedFunction::getRequiredFunctionHandle)));
            return functions;
        }

        public synchronized FunctionHandle getFunctionHandle(SqlFunctionId functionId) {
            return (FunctionHandle)this.functionHandles.get(functionId);
        }
    }
}

