/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.functionNamespace.execution.thrift.ThriftSqlFunctionExecutor;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.ThriftScalarFunctionImplementation;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class SqlFunctionExecutors {
    private final Map<RoutineCharacteristics.Language, FunctionImplementationType> supportedLanguages;
    private final ThriftSqlFunctionExecutor thriftSqlFunctionExecutor;

    @Inject
    public SqlFunctionExecutors(Map<RoutineCharacteristics.Language, FunctionImplementationType> supportedLanguages, ThriftSqlFunctionExecutor thriftSqlFunctionExecutor) {
        this.supportedLanguages = Objects.requireNonNull(supportedLanguages, "supportedLanguages is null");
        this.thriftSqlFunctionExecutor = Objects.requireNonNull(thriftSqlFunctionExecutor, "thriftSqlFunctionExecutor is null");
    }

    public Set<RoutineCharacteristics.Language> getSupportedLanguages() {
        return this.supportedLanguages.keySet();
    }

    public FunctionImplementationType getFunctionImplementationType(RoutineCharacteristics.Language language) {
        return this.supportedLanguages.get(language);
    }

    public CompletableFuture<Block> executeFunction(ScalarFunctionImplementation functionImplementation, Page input, List<Integer> channels, List<Type> argumentTypes, Type returnType) {
        Preconditions.checkArgument((boolean)(functionImplementation instanceof ThriftScalarFunctionImplementation), (Object)String.format("Only support ThriftScalarFunctionImplementation, got %s", functionImplementation.getClass()));
        return this.thriftSqlFunctionExecutor.executeFunction((ThriftScalarFunctionImplementation)functionImplementation, input, channels, argumentTypes, returnType);
    }
}

