/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.expressions.translator;

import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TranslatedExpression<T> {
    private final Optional<T> translated;
    private final RowExpression originalExpression;
    private final List<TranslatedExpression<T>> translatedArguments;

    public TranslatedExpression(Optional<T> translated, RowExpression originalExpression, List<TranslatedExpression<T>> translatedArguments) {
        this.translated = Objects.requireNonNull(translated);
        this.originalExpression = Objects.requireNonNull(originalExpression);
        this.translatedArguments = Objects.requireNonNull(translatedArguments);
    }

    public Optional<T> getTranslated() {
        return this.translated;
    }

    public RowExpression getOriginalExpression() {
        return this.originalExpression;
    }

    public List<TranslatedExpression<T>> getTranslatedArguments() {
        return this.translatedArguments;
    }

    public static <T> TranslatedExpression<T> untranslated(RowExpression originalExpression) {
        return new TranslatedExpression(Optional.empty(), originalExpression, ImmutableList.of());
    }

    public static <T> TranslatedExpression<T> untranslated(RowExpression originalExpression, List<TranslatedExpression<T>> translatedArguments) {
        return new TranslatedExpression(Optional.empty(), originalExpression, translatedArguments);
    }
}

