/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleConfig;
import com.facebook.presto.example.ExampleTable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class ExampleClient {
    private final Supplier<Map<String, Map<String, ExampleTable>>> schemas;

    @Inject
    public ExampleClient(ExampleConfig config, JsonCodec<Map<String, List<ExampleTable>>> catalogCodec) throws IOException {
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull(catalogCodec, (Object)"catalogCodec is null");
        this.schemas = Suppliers.memoize(ExampleClient.schemasSupplier(catalogCodec, config.getMetadata()));
    }

    public Set<String> getSchemaNames() {
        return ((Map)this.schemas.get()).keySet();
    }

    public Set<String> getTableNames(String schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        Map tables = (Map)((Map)this.schemas.get()).get(schema);
        if (tables == null) {
            return ImmutableSet.of();
        }
        return tables.keySet();
    }

    public ExampleTable getTable(String schema, String tableName) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        Map tables = (Map)((Map)this.schemas.get()).get(schema);
        if (tables == null) {
            return null;
        }
        return (ExampleTable)tables.get(tableName);
    }

    private static Supplier<Map<String, Map<String, ExampleTable>>> schemasSupplier(JsonCodec<Map<String, List<ExampleTable>>> catalogCodec, URI metadataUri) {
        return () -> {
            try {
                return ExampleClient.lookupSchemas(metadataUri, catalogCodec);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    private static Map<String, Map<String, ExampleTable>> lookupSchemas(URI metadataUri, JsonCodec<Map<String, List<ExampleTable>>> catalogCodec) throws IOException {
        URL result = metadataUri.toURL();
        String json = Resources.toString((URL)result, (Charset)StandardCharsets.UTF_8);
        Map catalog = (Map)catalogCodec.fromJson(json);
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)catalog, ExampleClient.resolveAndIndexTables(metadataUri)));
    }

    private static Function<List<ExampleTable>, Map<String, ExampleTable>> resolveAndIndexTables(URI metadataUri) {
        return tables -> {
            Iterable resolvedTables = Iterables.transform((Iterable)tables, ExampleClient.tableUriResolver(metadataUri));
            return ImmutableMap.copyOf((Map)Maps.uniqueIndex((Iterable)resolvedTables, ExampleTable::getName));
        };
    }

    private static Function<ExampleTable, ExampleTable> tableUriResolver(URI baseUri) {
        return table -> {
            ImmutableList sources = ImmutableList.copyOf((Iterable)Iterables.transform(table.getSources(), baseUri::resolve));
            return new ExampleTable(table.getName(), table.getColumns(), (List<URI>)sources);
        };
    }
}

