/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleConfig;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleHandleResolver;
import com.facebook.presto.example.ExampleMetadata;
import com.facebook.presto.example.ExampleRecordSetProvider;
import com.facebook.presto.example.ExampleSplitManager;
import com.facebook.presto.example.ExampleTable;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;

public class ExampleModule
implements Module {
    private final String connectorId;

    public ExampleModule(String connectorId) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connector id is null");
    }

    public void configure(Binder binder) {
        binder.bind(ExampleConnectorId.class).toInstance((Object)new ExampleConnectorId(this.connectorId));
        binder.bind(ExampleMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ExampleClient.class).in(Scopes.SINGLETON);
        binder.bind(ExampleSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ExampleRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ExampleHandleResolver.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(ExampleConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(ExampleTable.class));
    }
}

