/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumn;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.List;

public class ExampleTable {
    private final String name;
    private final List<ExampleColumn> columns;
    private final List<ColumnMetadata> columnsMetadata;
    private final List<URI> sources;

    @JsonCreator
    public ExampleTable(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<ExampleColumn> columns, @JsonProperty(value="sources") List<URI> sources) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.columns = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        this.sources = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sources, (Object)"sources is null")));
        int index = 0;
        ImmutableList.Builder columnsMetadata = ImmutableList.builder();
        for (ExampleColumn column : this.columns) {
            columnsMetadata.add((Object)new ColumnMetadata(column.getName(), column.getType(), index, false));
            ++index;
        }
        this.columnsMetadata = columnsMetadata.build();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<ExampleColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<URI> getSources() {
        return this.sources;
    }

    public List<ColumnMetadata> getColumnsMetadata() {
        return this.columnsMetadata;
    }

    public static Function<ExampleTable, String> nameGetter() {
        return new Function<ExampleTable, String>(){

            public String apply(ExampleTable table) {
                return table.getName();
            }
        };
    }
}

