/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleRecordCursor;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class ExampleRecordSet
implements RecordSet {
    private final List<ExampleColumnHandle> columnHandles;
    private final List<ColumnType> columnTypes;
    private final InputSupplier<InputStream> inputStreamSupplier;

    public ExampleRecordSet(ExampleSplit split, List<ExampleColumnHandle> columnHandles) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        this.columnHandles = (List)Preconditions.checkNotNull(columnHandles, (Object)"column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (ExampleColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        try {
            this.inputStreamSupplier = Resources.newInputStreamSupplier((URL)split.getUri().toURL());
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new ExampleRecordCursor(this.columnHandles, this.inputStreamSupplier);
    }
}

