/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;

public class ExampleRecordCursor
implements RecordCursor {
    private static final Splitter LINE_SPLITTER = Splitter.on((String)",").trimResults();
    private final List<ExampleColumnHandle> columnHandles;
    private final int[] fieldToColumnIndex;
    private final Iterator<String> lines;
    private final long totalBytes;
    private List<String> fields;

    public ExampleRecordCursor(List<ExampleColumnHandle> columnHandles, InputSupplier<InputStream> inputStreamSupplier) {
        this.columnHandles = columnHandles;
        this.fieldToColumnIndex = new int[columnHandles.size()];
        for (int i = 0; i < columnHandles.size(); ++i) {
            ExampleColumnHandle columnHandle = columnHandles.get(i);
            this.fieldToColumnIndex[i] = columnHandle.getOrdinalPosition();
        }
        try (CountingInputStream input = new CountingInputStream((InputStream)inputStreamSupplier.getInput());){
            this.lines = ByteStreams.asByteSource(inputStreamSupplier).asCharSource(StandardCharsets.UTF_8).readLines().iterator();
            this.totalBytes = input.getCount();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public ColumnType getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getColumnType();
    }

    public boolean advanceNextPosition() {
        if (!this.lines.hasNext()) {
            return false;
        }
        String line = this.lines.next();
        this.fields = LINE_SPLITTER.splitToList((CharSequence)line);
        return true;
    }

    private String getFieldValue(int field) {
        Preconditions.checkState((this.fields != null ? 1 : 0) != 0, (Object)"Cursor has not been advanced yes");
        int columnIndex = this.fieldToColumnIndex[field];
        return this.fields.get(columnIndex);
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, ColumnType.BOOLEAN);
        return Boolean.parseBoolean(this.getFieldValue(field));
    }

    public long getLong(int field) {
        this.checkFieldType(field, ColumnType.LONG);
        return Long.parseLong(this.getFieldValue(field));
    }

    public double getDouble(int field) {
        this.checkFieldType(field, ColumnType.DOUBLE);
        return Double.parseDouble(this.getFieldValue(field));
    }

    public byte[] getString(int field) {
        this.checkFieldType(field, ColumnType.STRING);
        return this.getFieldValue(field).getBytes(Charsets.UTF_8);
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return Strings.isNullOrEmpty((String)this.getFieldValue(field));
    }

    private void checkFieldType(int field, ColumnType expected) {
        ColumnType actual = this.getType(field);
        Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object[])new Object[]{field, expected, actual});
    }

    public void close() {
    }
}

