/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;

public class ExampleSplit
implements Split {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final URI uri;
    private final boolean remotelyAccessible;
    private final ImmutableList<HostAddress> addresses;

    @JsonCreator
    public ExampleSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="uri") URI uri) {
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schema name is null");
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connector id is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"table name is null");
        this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        this.remotelyAccessible = true;
        this.addresses = ImmutableList.of((Object)HostAddress.fromUri((URI)uri));
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public URI getUri() {
        return this.uri;
    }

    public boolean isRemotelyAccessible() {
        return this.remotelyAccessible;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }
}

