/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class ExampleColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String columnName;
    private final Type columnType;
    private final int ordinalPosition;

    @JsonCreator
    public ExampleColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="ordinalPosition") int ordinalPosition) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.ordinalPosition = ordinalPosition;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.columnName).setType(this.columnType).build();
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.columnName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExampleColumnHandle other = (ExampleColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.columnName, other.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("columnName", (Object)this.columnName).add("columnType", (Object)this.columnType).add("ordinalPosition", this.ordinalPosition).toString();
    }
}

