/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.example.ExampleTable;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.example.ExampleTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final ExampleClient exampleClient;

    @Inject
    public ExampleSplitManager(ExampleConnectorId connectorId, ExampleClient exampleClient) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.exampleClient = Objects.requireNonNull(exampleClient, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle handle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        ExampleTableLayoutHandle layoutHandle = (ExampleTableLayoutHandle)layout;
        ExampleTableHandle tableHandle = layoutHandle.getTable();
        ExampleTable table = this.exampleClient.getTable(tableHandle.getSchemaName(), tableHandle.getTableName());
        Preconditions.checkState((table != null ? 1 : 0) != 0, (String)"Table %s.%s no longer exists", (Object)tableHandle.getSchemaName(), (Object)tableHandle.getTableName());
        ArrayList<ExampleSplit> splits = new ArrayList<ExampleSplit>();
        for (URI uri : table.getSources()) {
            splits.add(new ExampleSplit(this.connectorId, tableHandle.getSchemaName(), tableHandle.getTableName(), uri));
        }
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }
}

