/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleRecordCursor;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;

public class ExampleRecordSet
implements RecordSet {
    private final List<ExampleColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final ByteSource byteSource;

    public ExampleRecordSet(ExampleSplit split, List<ExampleColumnHandle> columnHandles) {
        Objects.requireNonNull(split, "split is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (ExampleColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        try {
            this.byteSource = Resources.asByteSource((URL)split.getUri().toURL());
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new ExampleRecordCursor(this.columnHandles, this.byteSource);
    }
}

