/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleRecordSet;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.example.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleRecordSetProvider
implements ConnectorRecordSetProvider {
    private final String connectorId;

    @Inject
    public ExampleRecordSetProvider(ExampleConnectorId connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
    }

    public RecordSet getRecordSet(ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "partitionChunk is null");
        ExampleSplit exampleSplit = Types.checkType(split, ExampleSplit.class, "split");
        Preconditions.checkArgument((boolean)exampleSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)Types.checkType(columnHandle, ExampleColumnHandle.class, "handle"));
        }
        return new ExampleRecordSet(exampleSplit, (List<ExampleColumnHandle>)handles.build());
    }
}

