/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.zip.ZipException;

public class ZipUtil {
    public static final long DOS_EPOCH = new GregorianCalendar(1980, 0, 1, 0, 0, 0).getTimeInMillis();
    public static final long MAX_DOS_DATE = new GregorianCalendar(2107, 11, 31, 23, 59, 59).getTimeInMillis();
    private static final int DOS_MINUTE_OFFSET = 5;
    private static final int DOS_HOUR_OFFSET = 11;
    private static final int DOS_DAY_OFFSET = 16;
    private static final int DOS_MONTH_OFFSET = 21;
    private static final int DOS_YEAR_OFFSET = 25;

    private ZipUtil() {
    }

    private static byte[] integerToLittleEndian(byte[] buf, int offset, long value, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            buf[i + offset] = (byte)((value & 255L << i * 8) >> i * 8);
        }
        return buf;
    }

    public static byte[] shortToLittleEndian(short value) {
        return ZipUtil.integerToLittleEndian(new byte[2], 0, value, 2);
    }

    public static byte[] shortToLittleEndian(byte[] buf, int offset, short value) {
        return ZipUtil.integerToLittleEndian(buf, offset, value, 2);
    }

    public static byte[] intToLittleEndian(int value) {
        return ZipUtil.integerToLittleEndian(new byte[4], 0, value, 4);
    }

    public static byte[] intToLittleEndian(byte[] buf, int offset, int value) {
        return ZipUtil.integerToLittleEndian(buf, offset, value, 4);
    }

    public static byte[] longToLittleEndian(long value) {
        return ZipUtil.integerToLittleEndian(new byte[8], 0, value, 8);
    }

    public static byte[] longToLittleEndian(byte[] buf, int offset, long value) {
        return ZipUtil.integerToLittleEndian(buf, offset, value, 8);
    }

    public static short get16(byte[] source, int offset) {
        int a = source[offset + 0] & 0xFF;
        int b = source[offset + 1] & 0xFF;
        return (short)(b << 8 | a);
    }

    public static int get32(byte[] source, int offset) {
        int a = source[offset + 0] & 0xFF;
        int b = source[offset + 1] & 0xFF;
        int c = source[offset + 2] & 0xFF;
        int d = source[offset + 3] & 0xFF;
        return d << 24 | c << 16 | b << 8 | a;
    }

    public static long get64(byte[] source, int offset) {
        long a = (long)source[offset + 0] & 0xFFL;
        long b = (long)source[offset + 1] & 0xFFL;
        long c = (long)source[offset + 2] & 0xFFL;
        long d = (long)source[offset + 3] & 0xFFL;
        long e = (long)source[offset + 4] & 0xFFL;
        long f = (long)source[offset + 5] & 0xFFL;
        long g = (long)source[offset + 6] & 0xFFL;
        long h = (long)source[offset + 7] & 0xFFL;
        return h << 56 | g << 48 | f << 40 | e << 32 | d << 24 | c << 16 | b << 8 | a;
    }

    public static int getUnsignedShort(byte[] source, int offset) {
        return ZipUtil.get16(source, offset) & 0xFFFF;
    }

    public static long getUnsignedInt(byte[] source, int offset) {
        return (long)ZipUtil.get32(source, offset) & 0xFFFFFFFFL;
    }

    public static long getUnsignedLong(byte[] source, int offset) throws ZipException {
        long result = ZipUtil.get64(source, offset);
        if (result < 0L) {
            throw new ZipException("The requested unsigned long value is too large for Java's signed values. This Zip file is unsupported");
        }
        return result;
    }

    public static boolean isValidInDos(long timeMillis) {
        Calendar time = Calendar.getInstance();
        time.setTimeInMillis(timeMillis);
        Calendar minTime = Calendar.getInstance();
        minTime.setTimeInMillis(DOS_EPOCH);
        Calendar maxTime = Calendar.getInstance();
        maxTime.setTimeInMillis(MAX_DOS_DATE);
        return !time.before(minTime) && !time.after(maxTime);
    }

    public static long dosToUnixTime(int timestamp) {
        Calendar time = Calendar.getInstance();
        time.clear();
        time.set(13, (timestamp & 0x1F) * 2);
        time.set(12, timestamp >> 5 & 0x3F);
        time.set(11, timestamp >> 11 & 0x1F);
        time.set(5, timestamp >> 16 & 0x1F);
        time.set(2, (timestamp >> 21 & 0xF) - 1);
        time.set(1, (timestamp >> 25 & 0x7F) + 1980);
        return time.getTimeInMillis();
    }

    public static boolean arrayStartsWith(byte[] array, byte[] target) {
        if (array == null) {
            return false;
        }
        if (target == null) {
            return true;
        }
        if (target.length > array.length) {
            return false;
        }
        for (int i = 0; i < target.length; ++i) {
            if (array[i] == target[i]) continue;
            return false;
        }
        return true;
    }
}

