/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.segment;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.segment.SegmentColumnSource;
import com.facebook.presto.druid.segment.SegmentIndexSource;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.utils.SerializerUtils;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SimpleQueryableIndex;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.joda.time.Interval;

public class V9SegmentIndexSource
implements SegmentIndexSource {
    private static final Logger log = Logger.get(V9SegmentIndexSource.class);
    private static final String INDEX_METADATA_FILE_NAME = "index.drd";
    private static final String SEGMENT_METADATA_FILE_NAME = "metadata.drd";
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final SerializerUtils SERIALIZER_UTILS = new SerializerUtils();
    private final SegmentColumnSource segmentColumnSource;

    public V9SegmentIndexSource(SegmentColumnSource segmentColumnSource) {
        this.segmentColumnSource = Objects.requireNonNull(segmentColumnSource, "segmentColumnSource is null");
        NullHandling.initializeForTests();
    }

    @Override
    public QueryableIndex loadIndex(List<ColumnHandle> columnHandles) throws IOException {
        ByteBuffer indexBuffer = ByteBuffer.wrap(this.segmentColumnSource.getColumnData(INDEX_METADATA_FILE_NAME));
        GenericIndexed.read((ByteBuffer)indexBuffer, (ObjectStrategy)GenericIndexed.STRING_STRATEGY);
        GenericIndexed allDimensions = GenericIndexed.read((ByteBuffer)indexBuffer, (ObjectStrategy)GenericIndexed.STRING_STRATEGY);
        Interval dataInterval = Intervals.utc((long)indexBuffer.getLong(), (long)indexBuffer.getLong());
        Object segmentBitmapSerdeFactory = indexBuffer.hasRemaining() ? (BitmapSerdeFactory)JSON_MAPPER.readValue(SERIALIZER_UTILS.readString(indexBuffer), BitmapSerdeFactory.class) : new BitmapSerde.LegacyBitmapSerdeFactory();
        Metadata metadata = null;
        ByteBuffer metadataBuffer = ByteBuffer.wrap(this.segmentColumnSource.getColumnData(SEGMENT_METADATA_FILE_NAME));
        try {
            metadata = (Metadata)JSON_MAPPER.readValue(SERIALIZER_UTILS.readBytes(metadataBuffer, metadataBuffer.remaining()), Metadata.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            log.warn(e, "Failed to load metadata for segment");
        }
        HashMap<String, Supplier> columns = new HashMap<String, Supplier>();
        for (ColumnHandle columnHandle : columnHandles) {
            String columnName = ((DruidColumnHandle)columnHandle).getColumnName();
            columns.put(columnName, () -> this.createColumnHolder(columnName));
        }
        List availableDimensions = (List)Streams.stream((Iterator)allDimensions.iterator()).filter(columns::containsKey).collect(ImmutableList.toImmutableList());
        columns.put("__time", () -> this.createColumnHolder("__time"));
        ListIndexed indexed = new ListIndexed(availableDimensions);
        return new SimpleQueryableIndex(dataInterval, (Indexed)indexed, segmentBitmapSerdeFactory.getBitmapFactory(), columns, null, metadata, false);
    }

    private ColumnDescriptor readColumnDescriptor(ByteBuffer byteBuffer) throws IOException {
        return (ColumnDescriptor)JSON_MAPPER.readValue(SERIALIZER_UTILS.readString(byteBuffer), ColumnDescriptor.class);
    }

    private ColumnHolder createColumnHolder(String columnName) {
        try {
            ByteBuffer columnData = ByteBuffer.wrap(this.segmentColumnSource.getColumnData(columnName));
            ColumnDescriptor columnDescriptor = this.readColumnDescriptor(columnData);
            return columnDescriptor.read(columnData, ColumnConfig.DEFAULT, null);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }
}

