/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.segment;

import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.segment.IndexFileSource;
import com.facebook.presto.druid.segment.SegmentColumnSource;
import com.facebook.presto.druid.segment.SmooshFileMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SmooshedColumnSource
implements SegmentColumnSource {
    private static final String FILE_EXTENSION = "smoosh";
    private static final String SMOOSH_METADATA_FILE_NAME = SmooshedColumnSource.makeMetaFileName();
    private static final String VERSION_FILE_NAME = "version.bin";
    private final IndexFileSource indexFileSource;
    private final Map<String, SmooshFileMetadata> columnSmoosh = new HashMap<String, SmooshFileMetadata>();

    public SmooshedColumnSource(IndexFileSource indexFileSource) {
        this.indexFileSource = Objects.requireNonNull(indexFileSource, "indexFileSource is null");
        this.loadSmooshFileMetadata();
    }

    @Override
    public int getVersion() {
        try {
            return ByteBuffer.wrap(this.indexFileSource.readFile(VERSION_FILE_NAME)).getInt();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }

    @Override
    public byte[] getColumnData(String name) {
        SmooshFileMetadata metadata = this.columnSmoosh.get(name);
        if (metadata == null) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Internal file %s doesn't exist", name));
        }
        String fileName = SmooshedColumnSource.makeChunkFileName(metadata.getFileCount());
        int fileStart = metadata.getStartOffset();
        int fileSize = metadata.getEndOffset() - fileStart;
        byte[] buffer = new byte[fileSize];
        try {
            this.indexFileSource.readFile(fileName, fileStart, buffer);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
        return buffer;
    }

    private void loadSmooshFileMetadata() {
        try {
            byte[] metadata = this.indexFileSource.readFile(SMOOSH_METADATA_FILE_NAME);
            BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(metadata)));
            String line = in.readLine();
            if (line == null) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, "Malformed metadata file: first line should be version,maxChunkSize,numChunks, got null.");
            }
            String[] splits = line.split(",");
            if (!"v1".equals(splits[0])) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Malformed metadata file: unknown version[%s], v1 is all I know.", splits[0]));
            }
            if (splits.length != 3) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Malformed metadata file: wrong number of splits[%d] in line[%s]", splits.length, line));
            }
            while ((line = in.readLine()) != null) {
                splits = line.split(",");
                if (splits.length != 4) {
                    throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Malformed metadata file: wrong number of splits[%d] in line[%s]", splits.length, line));
                }
                this.columnSmoosh.put(splits[0], new SmooshFileMetadata(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), Integer.parseInt(splits[3])));
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }

    private static String makeMetaFileName() {
        return String.format("meta.%s", FILE_EXTENSION);
    }

    private static String makeChunkFileName(int i) {
        return String.format("%05d.%s", i, FILE_EXTENSION);
    }
}

