/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.metadata;

import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class DruidSegmentInfo {
    private static final String DEEP_STORAGE_TYPE_KEY = "type";
    private static final String DEEP_STORAGE_S3_SCHEMA_KEY = "S3Schema";
    private static final String DEEP_STORAGE_BUCKET_KEY = "bucket";
    private static final String DEEP_STORAGE_PATH_KEY = "path";
    private static final String S3A_SCHEMA = "s3a";
    private static final String S3N_SCHEMA = "s3n";
    private final String dataSource;
    private final String version;
    private final Optional<Map<String, String>> loadSpecification;
    private final Optional<Map<String, Object>> shardSpecification;
    private final Integer binaryVersion;
    private final long size;

    @JsonCreator
    public DruidSegmentInfo(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="version") String version, @JsonProperty(value="loadSpec") Optional<Map<String, String>> loadSpecification, @JsonProperty(value="shardSpec") @Nullable Optional<Map<String, Object>> shardSpecification, @JsonProperty(value="binaryVersion") Integer binaryVersion, @JsonProperty(value="size") long size) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.version = Objects.requireNonNull(version, "version is null");
        this.loadSpecification = Objects.requireNonNull(loadSpecification, "loadSpecification is null");
        this.shardSpecification = Objects.requireNonNull(shardSpecification, "shardSpecification is null");
        this.binaryVersion = Objects.requireNonNull(binaryVersion, "binaryVersion is null");
        this.size = size;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public Optional<Map<String, String>> getLoadSpecification() {
        return this.loadSpecification;
    }

    @JsonProperty
    public Optional<Map<String, Object>> getShardSpecification() {
        return this.shardSpecification;
    }

    @JsonProperty
    public Integer getBinaryVersion() {
        return this.binaryVersion;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    public DeepStorageType getDeepStorageType() {
        Map<String, String> loadSpecification = this.getLoadSpecification().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_METADATA_ERROR, String.format("Malformed segment loadSpecification: %s", this.getLoadSpecification())));
        return DeepStorageType.fromType(loadSpecification.get(DEEP_STORAGE_TYPE_KEY));
    }

    public URI getDeepStoragePath() {
        URI segmentLocURI;
        Map<String, String> loadSpec = this.getLoadSpecification().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_METADATA_ERROR, String.format("Malformed segment loadSpecification: %s", this.getLoadSpecification())));
        String type = loadSpec.get(DEEP_STORAGE_TYPE_KEY);
        try {
            switch (DeepStorageType.fromType(type)) {
                case S3: {
                    String s3schema = S3A_SCHEMA.equals(loadSpec.get(DEEP_STORAGE_S3_SCHEMA_KEY)) ? S3A_SCHEMA : S3N_SCHEMA;
                    segmentLocURI = URI.create(String.format("%s://%s/%s", s3schema, loadSpec.get(DEEP_STORAGE_BUCKET_KEY), loadSpec.get("key")));
                    break;
                }
                case HDFS: {
                    segmentLocURI = URI.create(loadSpec.get(DEEP_STORAGE_PATH_KEY));
                    break;
                }
                case GCS: {
                    segmentLocURI = URI.create(String.format("gs://%s/%s", loadSpec.get(DEEP_STORAGE_BUCKET_KEY), URLEncoder.encode(loadSpec.get(DEEP_STORAGE_PATH_KEY), "UTF-8")));
                    break;
                }
                case LOCAL: {
                    segmentLocURI = new URI("file", null, loadSpec.get(DEEP_STORAGE_PATH_KEY), null, null);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_METADATA_ERROR, String.format("Unsupported segment filesystem: %s", type));
                }
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_METADATA_ERROR, (Throwable)e);
        }
        return segmentLocURI;
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.version, this.loadSpecification, this.shardSpecification, this.binaryVersion, this.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DruidSegmentInfo that = (DruidSegmentInfo)obj;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.version, that.version) && Objects.equals(this.loadSpecification, that.loadSpecification) && Objects.equals(this.shardSpecification, that.shardSpecification) && Objects.equals(this.binaryVersion, that.binaryVersion) && Objects.equals(this.size, that.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataSource", (Object)this.dataSource).add("version", (Object)this.version).add("loadSpecification", this.loadSpecification).add("shardSpecification", this.shardSpecification).add("binaryVersion", (Object)this.binaryVersion).add("size", this.size).toString();
    }

    public static enum DeepStorageType {
        HDFS("hdfs"),
        S3("s3_zip"),
        GCS("google"),
        LOCAL("local");

        private final String type;

        private DeepStorageType(String type) {
            this.type = type;
        }

        static DeepStorageType fromType(String type) {
            for (DeepStorageType deepStorageType : DeepStorageType.values()) {
                if (!deepStorageType.type.equalsIgnoreCase(type)) continue;
                return deepStorageType;
            }
            throw new IllegalArgumentException("Unknown deep storage type: " + type);
        }
    }
}

