/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.column;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.column.DoubleColumnReader;
import com.facebook.presto.druid.column.FloatColumnReader;
import com.facebook.presto.druid.column.LongColumnReader;
import com.facebook.presto.druid.column.StringColumnReader;
import com.facebook.presto.druid.column.TimestampColumnReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import org.apache.druid.segment.ColumnValueSelector;

public interface ColumnReader {
    public Block readBlock(Type var1, int var2);

    public static ColumnReader createColumnReader(Type type, ColumnValueSelector valueSelector) {
        if (type == VarcharType.VARCHAR) {
            return new StringColumnReader(valueSelector);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new DoubleColumnReader(valueSelector);
        }
        if (type == BigintType.BIGINT) {
            return new LongColumnReader(valueSelector);
        }
        if (type.equals(RealType.REAL)) {
            return new FloatColumnReader(valueSelector);
        }
        if (type == TimestampType.TIMESTAMP) {
            return new TimestampColumnReader(valueSelector);
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_UNSUPPORTED_TYPE_ERROR, String.format("Unsupported type: %s", type));
    }
}

