/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class DruidSessionProperties {
    private static final String COMPUTE_PUSHDOWN = "compute_pushdown_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    public static boolean isComputePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(COMPUTE_PUSHDOWN, Boolean.class);
    }

    @Inject
    public DruidSessionProperties(DruidConfig druidConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)COMPUTE_PUSHDOWN, (String)"Pushdown query processing to druid", (Boolean)druidConfig.isComputePushdownEnabled(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

