/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidTableHandle;
import com.facebook.presto.druid.DruidTableLayoutHandle;
import com.facebook.presto.druid.ingestion.DruidIngestionTableHandle;
import com.facebook.presto.druid.metadata.DruidColumnInfo;
import com.facebook.presto.druid.metadata.DruidColumnType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DruidMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(DruidMetadata.class);
    private final DruidClient druidClient;

    @Inject
    public DruidMetadata(DruidClient druidClient) {
        this.druidClient = Objects.requireNonNull(druidClient, "druidClient is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.druidClient.getSchemas();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        String remoteTableName = this.druidClient.toRemoteTable(schemaTableName).map(DruidClient.RemoteTableObject::getOnlyRemoteTableName).orElse(schemaTableName.getTableName());
        return this.druidClient.getTables().stream().filter(name -> name.equals(remoteTableName)).map(name -> new DruidTableHandle(this.druidClient.getSchema(), remoteTableName, Optional.empty())).findFirst().orElse(null);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        DruidTableHandle handle = (DruidTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new DruidTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DruidTableHandle druidTable = (DruidTableHandle)tableHandle;
        List columns = (List)this.druidClient.getColumnDataType(druidTable.getTableName()).stream().map(column -> DruidMetadata.toColumnMetadata(column)).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(druidTable.toSchemaTableName(), columns);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String table : this.druidClient.getTables()) {
            boolean isAmbiguous = this.druidClient.toRemoteTable(new SchemaTableName(this.druidClient.getSchema(), table)).filter(DruidClient.RemoteTableObject::isAmbiguous).isPresent();
            if (!isAmbiguous) {
                tableNames.add((Object)new SchemaTableName(this.druidClient.getSchema(), table));
                continue;
            }
            log.debug("Filtered out [%s.%s] from list of tables due to ambiguous name", new Object[]{this.druidClient.getSchema(), table});
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DruidTableHandle druidTable = (DruidTableHandle)tableHandle;
        return (Map)this.druidClient.getColumnDataType(druidTable.getTableName()).stream().collect(ImmutableMap.toImmutableMap(DruidColumnInfo::getColumnName, column -> DruidMetadata.toColumnHandle(column)));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, this.getTableHandle(session, tableName));
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((DruidColumnHandle)columnHandle).getColumnMetadata();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DruidTableHandle druidTableHandle = (DruidTableHandle)tableHandle;
        List<DruidColumnInfo> columns = this.druidClient.getColumnDataType(druidTableHandle.getTableName());
        return new DruidIngestionTableHandle(druidTableHandle.getSchemaName(), druidTableHandle.getTableName(), columns);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        return new DruidIngestionTableHandle(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), tableMetadata.getColumns().stream().map(column -> new DruidColumnInfo(column.getName(), DruidColumnType.fromPrestoType(column.getType()))).collect(Collectors.toList()));
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTableName() == null) {
            return this.listTables(session, Optional.of(prefix.getSchemaName()));
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    private static ColumnMetadata toColumnMetadata(DruidColumnInfo column) {
        return new ColumnMetadata(column.getColumnName(), column.getDataType().getPrestoType());
    }

    private static ColumnHandle toColumnHandle(DruidColumnInfo column) {
        return new DruidColumnHandle(column.getColumnName(), column.getDataType().getPrestoType());
    }
}

