/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Objects;

public abstract class DruidAggregationColumnNode {
    private final ExpressionType expressionType;
    private final VariableReferenceExpression outputColumn;

    public DruidAggregationColumnNode(ExpressionType expressionType, VariableReferenceExpression outputColumn) {
        this.expressionType = Objects.requireNonNull(expressionType, "expressionType is null");
        this.outputColumn = Objects.requireNonNull(outputColumn, "outputColumn is null");
    }

    public VariableReferenceExpression getOutputColumn() {
        return this.outputColumn;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public static class AggregationFunctionColumnNode
    extends DruidAggregationColumnNode {
        private final CallExpression callExpression;

        public AggregationFunctionColumnNode(VariableReferenceExpression output, CallExpression callExpression) {
            super(ExpressionType.AGGREGATE, output);
            this.callExpression = Objects.requireNonNull(callExpression, "callExpression is null");
        }

        public CallExpression getCallExpression() {
            return this.callExpression;
        }

        public String toString() {
            return this.callExpression.toString();
        }
    }

    public static class GroupByColumnNode
    extends DruidAggregationColumnNode {
        private final VariableReferenceExpression inputColumn;

        public GroupByColumnNode(VariableReferenceExpression inputColumn, VariableReferenceExpression output) {
            super(ExpressionType.GROUP_BY, output);
            this.inputColumn = Objects.requireNonNull(inputColumn, "inputColumn is null");
        }

        public VariableReferenceExpression getInputColumn() {
            return this.inputColumn;
        }

        public String toString() {
            return this.inputColumn.toString();
        }
    }

    public static enum ExpressionType {
        GROUP_BY,
        AGGREGATE;

    }
}

