/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.zip.ZipFileData;
import com.facebook.presto.druid.zip.ZipUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;

public class EndOfCentralDirectoryRecord {
    public static final int SIGNATURE = 101010256;
    public static final int FIXED_DATA_SIZE = 22;
    public static final int DISK_NUMBER_OFFSET = 4;
    public static final int CD_DISK_OFFSET = 6;
    public static final int DISK_ENTRIES_OFFSET = 8;
    public static final int TOTAL_ENTRIES_OFFSET = 10;
    public static final int CD_SIZE_OFFSET = 12;
    public static final int CD_OFFSET_OFFSET = 16;
    public static final int COMMENT_LENGTH_OFFSET = 20;

    private EndOfCentralDirectoryRecord() {
    }

    public static void read(ZipFileData zipFileData, DataInputSource dataInputSource, long offset) throws IOException {
        long position = offset;
        byte[] fixedSizeData = new byte[22];
        dataInputSource.readFully(position, fixedSizeData, 0, 22);
        position += 22L;
        if (!ZipUtil.arrayStartsWith(fixedSizeData, ZipUtil.intToLittleEndian(101010256))) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Malformed End of Central Directory Record; does not start with %08x", 101010256));
        }
        byte[] comment = new byte[ZipUtil.getUnsignedShort(fixedSizeData, 20)];
        if (comment.length > 0) {
            dataInputSource.readFully(position, comment, 0, comment.length);
        }
        short diskNumber = ZipUtil.get16(fixedSizeData, 4);
        short centralDirectoryDisk = ZipUtil.get16(fixedSizeData, 6);
        short entriesOnDisk = ZipUtil.get16(fixedSizeData, 8);
        short totalEntries = ZipUtil.get16(fixedSizeData, 10);
        int centralDirectorySize = ZipUtil.get32(fixedSizeData, 12);
        int centralDirectoryOffset = ZipUtil.get32(fixedSizeData, 16);
        if (diskNumber == -1 || centralDirectoryDisk == -1 || entriesOnDisk == -1 || totalEntries == -1 || centralDirectorySize == -1 || centralDirectoryOffset == -1) {
            zipFileData.setMaybeZip64(true);
        }
        zipFileData.setComment(comment);
        zipFileData.setCentralDirectorySize(ZipUtil.getUnsignedInt(fixedSizeData, 12));
        zipFileData.setCentralDirectoryOffset(ZipUtil.getUnsignedInt(fixedSizeData, 16));
        zipFileData.setExpectedEntries(ZipUtil.getUnsignedShort(fixedSizeData, 10));
    }
}

