/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.authentication;

import com.facebook.airlift.http.client.BasicAuthRequestFilter;
import com.facebook.airlift.http.client.HttpRequestFilter;
import com.facebook.airlift.http.client.Request;
import com.facebook.presto.druid.DruidConfig;
import java.util.Objects;
import javax.inject.Inject;

public class DruidBasicAuthHttpRequestFilter
implements HttpRequestFilter {
    private final BasicAuthRequestFilter filter;

    @Inject
    public DruidBasicAuthHttpRequestFilter(DruidConfig config) {
        String username = Objects.requireNonNull(config.getBasicAuthenticationUsername(), "username cannot be null when using basic authentication");
        String password = Objects.requireNonNull(config.getBasicAuthenticationPassword(), "password cannot be null when using basic authentication");
        this.filter = new BasicAuthRequestFilter(username, password);
    }

    public Request filterRequest(Request request) {
        return this.filter.filterRequest(request);
    }
}

