/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidQueryGenerator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class DruidQueryGeneratorContext {
    private final Map<VariableReferenceExpression, Selection> selections;
    private final Set<VariableReferenceExpression> groupByColumns;
    private final Set<VariableReferenceExpression> hiddenColumnSet;
    private final Set<VariableReferenceExpression> variablesInAggregation;
    private final Optional<String> from;
    private final Optional<String> filter;
    private final OptionalLong limit;
    private final int aggregations;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("selections", this.selections).add("groupByColumns", this.groupByColumns).add("hiddenColumnSet", this.hiddenColumnSet).add("variablesInAggregation", this.variablesInAggregation).add("from", this.from).add("filter", this.filter).add("limit", (Object)this.limit).add("aggregations", this.aggregations).toString();
    }

    DruidQueryGeneratorContext() {
        this(new LinkedHashMap<VariableReferenceExpression, Selection>(), null);
    }

    DruidQueryGeneratorContext(Map<VariableReferenceExpression, Selection> selections, String from) {
        this(selections, Optional.ofNullable(from), Optional.empty(), OptionalLong.empty(), 0, new HashSet<VariableReferenceExpression>(), new HashSet<VariableReferenceExpression>(), new HashSet<VariableReferenceExpression>());
    }

    private DruidQueryGeneratorContext(Map<VariableReferenceExpression, Selection> selections, Optional<String> from, Optional<String> filter, OptionalLong limit, int aggregations, Set<VariableReferenceExpression> groupByColumns, Set<VariableReferenceExpression> variablesInAggregation, Set<VariableReferenceExpression> hiddenColumnSet) {
        this.selections = new LinkedHashMap<VariableReferenceExpression, Selection>(Objects.requireNonNull(selections, "selections can't be null"));
        this.from = Objects.requireNonNull(from, "source can't be null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.aggregations = aggregations;
        this.groupByColumns = new LinkedHashSet<VariableReferenceExpression>((Collection)Objects.requireNonNull(groupByColumns, "groupByColumns can't be null. It could be empty if not available"));
        this.hiddenColumnSet = Objects.requireNonNull(hiddenColumnSet, "hidden column set is null");
        this.variablesInAggregation = Objects.requireNonNull(variablesInAggregation, "variables in aggregation is null");
    }

    public DruidQueryGeneratorContext withFilter(String filter) {
        Preconditions.checkState((!this.hasFilter() ? 1 : 0) != 0, (Object)"Druid doesn't support filters at multiple levels");
        return new DruidQueryGeneratorContext(this.selections, this.from, Optional.of(filter), this.limit, this.aggregations, this.groupByColumns, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public DruidQueryGeneratorContext withProject(Map<VariableReferenceExpression, Selection> newSelections) {
        return new DruidQueryGeneratorContext(newSelections, this.from, this.filter, this.limit, this.aggregations, this.groupByColumns, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public DruidQueryGeneratorContext withLimit(long limit) {
        if (limit <= 0L || limit > Long.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_QUERY_GENERATOR_FAILURE, "Invalid limit: " + limit);
        }
        Preconditions.checkState((!this.hasLimit() ? 1 : 0) != 0, (Object)"Limit already exists. Druid doesn't support limit on top of another limit");
        return new DruidQueryGeneratorContext(this.selections, this.from, this.filter, OptionalLong.of(limit), this.aggregations, this.groupByColumns, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public DruidQueryGeneratorContext withAggregation(Map<VariableReferenceExpression, Selection> newSelections, Set<VariableReferenceExpression> newGroupByColumns, int newAggregations, Set<VariableReferenceExpression> newHiddenColumnSet) {
        AtomicBoolean pushDownDistinctCount = new AtomicBoolean(false);
        newSelections.values().forEach(selection -> {
            if (selection.getDefinition().startsWith("distinctCount".toUpperCase(Locale.ENGLISH))) {
                pushDownDistinctCount.set(true);
            }
        });
        ImmutableMap targetSelections = newSelections;
        if (pushDownDistinctCount.get()) {
            newHiddenColumnSet = ImmutableSet.of();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<VariableReferenceExpression, Selection> entry : newSelections.entrySet()) {
                if (entry.getValue().getDefinition().startsWith("distinctCount".toUpperCase(Locale.ENGLISH))) {
                    String definition = entry.getValue().getDefinition();
                    int start = definition.indexOf("(");
                    int end = definition.indexOf(")");
                    String countDistinctClause = "count ( distinct " + DruidQueryGeneratorContext.escapeSqlIdentifier(definition.substring(start + 1, end)) + ")";
                    Selection countDistinctSelection = new Selection(countDistinctClause, entry.getValue().getOrigin());
                    builder.put((Object)entry.getKey(), (Object)countDistinctSelection);
                    continue;
                }
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            targetSelections = builder.build();
        } else {
            Preconditions.checkState((!this.hasAggregation() ? 1 : 0) != 0, (Object)"Druid doesn't support aggregation on top of the aggregated data");
        }
        Preconditions.checkState((!this.hasLimit() ? 1 : 0) != 0, (Object)"Druid doesn't support aggregation on top of the limit");
        Preconditions.checkState((newAggregations > 0 ? 1 : 0) != 0, (Object)"Invalid number of aggregations");
        return new DruidQueryGeneratorContext((Map<VariableReferenceExpression, Selection>)targetSelections, this.from, this.filter, this.limit, newAggregations, newGroupByColumns, this.variablesInAggregation, (Set<VariableReferenceExpression>)newHiddenColumnSet);
    }

    private static String escapeSqlIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    public DruidQueryGeneratorContext withVariablesInAggregation(Set<VariableReferenceExpression> newVariablesInAggregation) {
        return new DruidQueryGeneratorContext(this.selections, this.from, this.filter, this.limit, this.aggregations, this.groupByColumns, newVariablesInAggregation, this.hiddenColumnSet);
    }

    private boolean hasLimit() {
        return this.limit.isPresent();
    }

    private boolean hasFilter() {
        return this.filter.isPresent();
    }

    private boolean hasAggregation() {
        return this.aggregations > 0;
    }

    public Map<VariableReferenceExpression, Selection> getSelections() {
        return this.selections;
    }

    public Set<VariableReferenceExpression> getHiddenColumnSet() {
        return this.hiddenColumnSet;
    }

    Set<VariableReferenceExpression> getVariablesInAggregation() {
        return this.variablesInAggregation;
    }

    public DruidQueryGenerator.GeneratedDql toQuery() {
        if (this.hasLimit() && this.aggregations > 1 && !this.groupByColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_QUERY_GENERATOR_FAILURE, "Could not pushdown multiple aggregates in the presence of group by and limit");
        }
        String expressions = this.selections.entrySet().stream().map(s -> ((Selection)s.getValue()).getEscapedDefinition()).collect(Collectors.joining(", "));
        if (expressions.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_QUERY_GENERATOR_FAILURE, "Empty Druid query");
        }
        String tableName = this.from.orElseThrow(() -> new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_QUERY_GENERATOR_FAILURE, "Table name missing in Druid query"));
        String query = "SELECT " + expressions + " FROM " + DruidQueryGeneratorContext.escapeSqlIdentifier(tableName);
        boolean pushdown = false;
        if (this.filter.isPresent()) {
            query = query + " WHERE " + this.filter.get();
            pushdown = true;
        }
        if (!this.groupByColumns.isEmpty()) {
            String groupByExpression = this.groupByColumns.stream().map(expression -> this.selections.containsKey(expression) ? this.selections.get(expression).getEscapedDefinition() : expression.getName()).collect(Collectors.joining(", "));
            query = query + " GROUP BY " + groupByExpression;
            pushdown = true;
        }
        if (this.hasAggregation()) {
            pushdown = true;
        }
        if (this.limit.isPresent()) {
            query = query + " LIMIT " + this.limit.getAsLong();
            pushdown = true;
        }
        return new DruidQueryGenerator.GeneratedDql(tableName, query, pushdown);
    }

    public Map<VariableReferenceExpression, DruidColumnHandle> getAssignments() {
        LinkedHashMap<VariableReferenceExpression, DruidColumnHandle> result = new LinkedHashMap<VariableReferenceExpression, DruidColumnHandle>();
        this.selections.entrySet().stream().filter(e -> !this.hiddenColumnSet.contains(e.getKey())).forEach(entry -> {
            VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
            Selection selection = (Selection)entry.getValue();
            DruidColumnHandle handle = selection.getOrigin() == Origin.TABLE_COLUMN ? new DruidColumnHandle(selection.getDefinition(), variable.getType(), DruidColumnHandle.DruidColumnType.REGULAR) : new DruidColumnHandle(variable, DruidColumnHandle.DruidColumnType.DERIVED);
            result.put(variable, handle);
        });
        return result;
    }

    public DruidQueryGeneratorContext withOutputColumns(List<VariableReferenceExpression> outputColumns) {
        LinkedHashMap<VariableReferenceExpression, Selection> newSelections = new LinkedHashMap<VariableReferenceExpression, Selection>();
        outputColumns.forEach(o -> newSelections.put((VariableReferenceExpression)o, Objects.requireNonNull(this.selections.get(o), "Cannot find the selection " + o + " in the original context " + this)));
        this.selections.entrySet().stream().filter(e -> this.hiddenColumnSet.contains(e.getKey())).forEach(e -> {
            Selection cfr_ignored_0 = (Selection)newSelections.put((VariableReferenceExpression)e.getKey(), (Selection)e.getValue());
        });
        return new DruidQueryGeneratorContext(newSelections, this.from, this.filter, this.limit, this.aggregations, this.groupByColumns, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public static class Selection {
        private final String definition;
        private final Origin origin;

        public Selection(String definition, Origin origin) {
            this.definition = definition;
            this.origin = origin;
        }

        public String getDefinition() {
            return this.definition;
        }

        public String getEscapedDefinition() {
            if (this.origin == Origin.TABLE_COLUMN) {
                return DruidQueryGeneratorContext.escapeSqlIdentifier(this.definition);
            }
            return this.definition;
        }

        public Origin getOrigin() {
            return this.origin;
        }

        public String toString() {
            return this.definition;
        }
    }

    public static enum Origin {
        TABLE_COLUMN,
        DERIVED,
        LITERAL;

    }
}

