/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.druid.DruidAggregationColumnNode;
import com.facebook.presto.druid.DruidAggregationProjectConverter;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidExpression;
import com.facebook.presto.druid.DruidFilterExpressionConverter;
import com.facebook.presto.druid.DruidProjectExpressionConverter;
import com.facebook.presto.druid.DruidPushdownUtils;
import com.facebook.presto.druid.DruidQueryGeneratorContext;
import com.facebook.presto.druid.DruidTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DruidQueryGenerator {
    private static final Logger log = Logger.get(DruidQueryGenerator.class);
    private static final Map<String, String> UNARY_AGGREGATION_MAP = ImmutableMap.of((Object)"min", (Object)"min", (Object)"max", (Object)"max", (Object)"avg", (Object)"avg", (Object)"sum", (Object)"sum", (Object)"distinctcount", (Object)"DISTINCTCOUNT");
    private final TypeManager typeManager;
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;
    private final DruidProjectExpressionConverter druidProjectExpressionConverter;

    @Inject
    public DruidQueryGenerator(TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution) {
        this.typeManager = Objects.requireNonNull(typeManager, "type manager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function metadata manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
        this.druidProjectExpressionConverter = new DruidProjectExpressionConverter(typeManager, standardFunctionResolution);
    }

    public Optional<DruidQueryGeneratorResult> generate(PlanNode plan, ConnectorSession session) {
        try {
            DruidQueryGeneratorContext context = (DruidQueryGeneratorContext)Objects.requireNonNull(plan.accept((PlanVisitor)new DruidQueryPlanVisitor(session), (Object)new DruidQueryGeneratorContext()), "Resulting context is null");
            return Optional.of(new DruidQueryGeneratorResult(context.toQuery(), context));
        }
        catch (PrestoException e) {
            log.debug((Throwable)e, "Possibly benign error when pushing plan into scan node %s", new Object[]{plan});
            return Optional.empty();
        }
    }

    private class DruidQueryPlanVisitor
    extends PlanVisitor<DruidQueryGeneratorContext, DruidQueryGeneratorContext> {
        private final ConnectorSession session;

        protected DruidQueryPlanVisitor(ConnectorSession session) {
            this.session = session;
        }

        public DruidQueryGeneratorContext visitPlan(PlanNode node, DruidQueryGeneratorContext context) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported pushdown for Druid connector with plan node of type " + node);
        }

        protected VariableReferenceExpression getVariableReference(RowExpression expression) {
            if (expression instanceof VariableReferenceExpression) {
                return (VariableReferenceExpression)expression;
            }
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported pushdown for Druid connector. Expect variable reference, but get: " + expression);
        }

        public DruidQueryGeneratorContext visitMarkDistinct(MarkDistinctNode node, DruidQueryGeneratorContext context) {
            Objects.requireNonNull(context, "context is null");
            return (DruidQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public DruidQueryGeneratorContext visitFilter(FilterNode node, DruidQueryGeneratorContext context) {
            context = (DruidQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
            Objects.requireNonNull(context, "context is null");
            Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> selections = context.getSelections();
            DruidFilterExpressionConverter druidFilterExpressionConverter = new DruidFilterExpressionConverter(DruidQueryGenerator.this.typeManager, DruidQueryGenerator.this.functionMetadataManager, DruidQueryGenerator.this.standardFunctionResolution, this.session);
            String filter = ((DruidExpression)node.getPredicate().accept((RowExpressionVisitor)druidFilterExpressionConverter, selections::get)).getDefinition();
            return context.withFilter(filter).withOutputColumns(node.getOutputVariables());
        }

        public DruidQueryGeneratorContext visitProject(ProjectNode node, DruidQueryGeneratorContext contextIn) {
            DruidQueryGeneratorContext context = (DruidQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            Objects.requireNonNull(context, "context is null");
            LinkedHashMap<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> newSelections = new LinkedHashMap<VariableReferenceExpression, DruidQueryGeneratorContext.Selection>();
            node.getOutputVariables().forEach(variable -> {
                RowExpression expression = node.getAssignments().get(variable);
                DruidProjectExpressionConverter projectExpressionConverter = DruidQueryGenerator.this.druidProjectExpressionConverter;
                if (contextIn.getVariablesInAggregation().contains(variable)) {
                    projectExpressionConverter = new DruidAggregationProjectConverter(DruidQueryGenerator.this.typeManager, DruidQueryGenerator.this.functionMetadataManager, DruidQueryGenerator.this.standardFunctionResolution);
                }
                DruidExpression druidExpression = (DruidExpression)expression.accept((RowExpressionVisitor)projectExpressionConverter, context.getSelections());
                newSelections.put((VariableReferenceExpression)variable, new DruidQueryGeneratorContext.Selection(druidExpression.getDefinition(), druidExpression.getOrigin()));
            });
            return context.withProject(newSelections);
        }

        public DruidQueryGeneratorContext visitLimit(LimitNode node, DruidQueryGeneratorContext context) {
            Preconditions.checkArgument((!node.isPartial() ? 1 : 0) != 0, (Object)"Druid query generator cannot handle partial limit");
            context = (DruidQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
            Objects.requireNonNull(context, "context is null");
            return context.withLimit(node.getCount()).withOutputColumns(node.getOutputVariables());
        }

        public DruidQueryGeneratorContext visitTableScan(TableScanNode node, DruidQueryGeneratorContext contextIn) {
            DruidTableHandle tableHandle = (DruidTableHandle)node.getTable().getConnectorHandle();
            Preconditions.checkArgument((!tableHandle.getDql().isPresent() ? 1 : 0) != 0, (Object)"Druid tableHandle should not have dql before pushdown");
            LinkedHashMap<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> selections = new LinkedHashMap<VariableReferenceExpression, DruidQueryGeneratorContext.Selection>();
            node.getOutputVariables().forEach(outputColumn -> {
                DruidColumnHandle druidColumn = (DruidColumnHandle)node.getAssignments().get(outputColumn);
                Preconditions.checkArgument((boolean)druidColumn.getType().equals((Object)DruidColumnHandle.DruidColumnType.REGULAR), (Object)("Unexpected druid column handle that is not regular: " + druidColumn));
                selections.put((VariableReferenceExpression)outputColumn, new DruidQueryGeneratorContext.Selection(druidColumn.getColumnName(), DruidQueryGeneratorContext.Origin.TABLE_COLUMN));
            });
            return new DruidQueryGeneratorContext(selections, tableHandle.getTableName());
        }

        public DruidQueryGeneratorContext visitAggregation(AggregationNode node, DruidQueryGeneratorContext contextIn) {
            List<DruidAggregationColumnNode> aggregationColumnNodes = DruidPushdownUtils.computeAggregationNodes(node);
            HashSet<VariableReferenceExpression> variablesInAggregation = new HashSet<VariableReferenceExpression>();
            block8: for (DruidAggregationColumnNode expression : aggregationColumnNodes) {
                switch (expression.getExpressionType()) {
                    case GROUP_BY: {
                        DruidAggregationColumnNode.GroupByColumnNode groupByColumn = (DruidAggregationColumnNode.GroupByColumnNode)expression;
                        VariableReferenceExpression groupByInputColumn = this.getVariableReference((RowExpression)groupByColumn.getInputColumn());
                        variablesInAggregation.add(groupByInputColumn);
                        continue block8;
                    }
                    case AGGREGATE: {
                        DruidAggregationColumnNode.AggregationFunctionColumnNode aggregationNode = (DruidAggregationColumnNode.AggregationFunctionColumnNode)expression;
                        variablesInAggregation.addAll(aggregationNode.getCallExpression().getArguments().stream().filter(argument -> argument instanceof VariableReferenceExpression).map(argument -> (VariableReferenceExpression)argument).collect(Collectors.toList()));
                        continue block8;
                    }
                }
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported pushdown for Druid connector. Unknown aggregation expression:" + (Object)((Object)expression.getExpressionType()));
            }
            DruidQueryGeneratorContext context = (DruidQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)contextIn.withVariablesInAggregation(variablesInAggregation));
            Objects.requireNonNull(context, "context is null");
            Preconditions.checkArgument((!node.getStep().isOutputPartial() ? 1 : 0) != 0, (Object)"Druid pushdown does not support partial aggregations");
            LinkedHashMap<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> newSelections = new LinkedHashMap<VariableReferenceExpression, DruidQueryGeneratorContext.Selection>();
            LinkedHashSet<VariableReferenceExpression> groupByColumns = new LinkedHashSet<VariableReferenceExpression>();
            HashSet<VariableReferenceExpression> hiddenColumnSet = new HashSet<VariableReferenceExpression>(context.getHiddenColumnSet());
            int aggregations = 0;
            boolean groupByExists = false;
            block9: for (DruidAggregationColumnNode expression : aggregationColumnNodes) {
                switch (expression.getExpressionType()) {
                    case GROUP_BY: {
                        DruidAggregationColumnNode.GroupByColumnNode groupByColumn = (DruidAggregationColumnNode.GroupByColumnNode)expression;
                        VariableReferenceExpression groupByInputColumn = this.getVariableReference((RowExpression)groupByColumn.getInputColumn());
                        VariableReferenceExpression outputColumn = this.getVariableReference((RowExpression)groupByColumn.getOutputColumn());
                        DruidQueryGeneratorContext.Selection druidColumn = Objects.requireNonNull(context.getSelections().get(groupByInputColumn), "Group By column " + groupByInputColumn + " doesn't exist in input " + context.getSelections());
                        newSelections.put(outputColumn, new DruidQueryGeneratorContext.Selection(druidColumn.getDefinition(), druidColumn.getOrigin()));
                        groupByColumns.add(outputColumn);
                        groupByExists = true;
                        continue block9;
                    }
                    case AGGREGATE: {
                        DruidAggregationColumnNode.AggregationFunctionColumnNode aggregationNode = (DruidAggregationColumnNode.AggregationFunctionColumnNode)expression;
                        String druidAggregationFunction = this.handleAggregationFunction(aggregationNode.getCallExpression(), context.getSelections());
                        newSelections.put(this.getVariableReference((RowExpression)aggregationNode.getOutputColumn()), new DruidQueryGeneratorContext.Selection(druidAggregationFunction, DruidQueryGeneratorContext.Origin.DERIVED));
                        ++aggregations;
                        continue block9;
                    }
                }
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported pushdown for Druid connector. Unknown aggregation expression:" + (Object)((Object)expression.getExpressionType()));
            }
            if (groupByExists && aggregations == 0) {
                VariableReferenceExpression hidden = new VariableReferenceExpression(UUID.randomUUID().toString(), (Type)BigintType.BIGINT);
                newSelections.put(hidden, new DruidQueryGeneratorContext.Selection("count(*)", DruidQueryGeneratorContext.Origin.DERIVED));
                hiddenColumnSet.add(hidden);
                ++aggregations;
            }
            return context.withAggregation(newSelections, groupByColumns, aggregations, hiddenColumnSet);
        }

        private String handleAggregationFunction(CallExpression aggregation, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> inputSelections) {
            String prestoAggregation = aggregation.getDisplayName().toLowerCase(Locale.ENGLISH);
            List parameters = aggregation.getArguments();
            if (prestoAggregation.equals("count")) {
                if (parameters.size() <= 1) {
                    return String.format("count(%s)", parameters.isEmpty() ? "*" : inputSelections.get(this.getVariableReference((RowExpression)parameters.get(0))));
                }
            } else if (UNARY_AGGREGATION_MAP.containsKey(prestoAggregation) && aggregation.getArguments().size() == 1) {
                return String.format("%s(%s)", UNARY_AGGREGATION_MAP.get(prestoAggregation), inputSelections.get(this.getVariableReference((RowExpression)parameters.get(0))));
            }
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported pushdown for Druid connector. Aggregation function: " + aggregation + " not supported");
        }
    }

    public static class GeneratedDql {
        final String table;
        final String dql;
        final boolean pushdown;

        @JsonCreator
        public GeneratedDql(@JsonProperty(value="table") String table, @JsonProperty(value="dql") String dql, @JsonProperty(value="pushdown") boolean pushdown) {
            this.table = table;
            this.dql = dql;
            this.pushdown = pushdown;
        }

        @JsonProperty(value="dql")
        public String getDql() {
            return this.dql;
        }

        @JsonProperty(value="table")
        public String getTable() {
            return this.table;
        }

        @JsonProperty(value="pushdown")
        public boolean getPushdown() {
            return this.pushdown;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dql", (Object)this.dql).add("table", (Object)this.table).add("pushdown", this.pushdown).toString();
        }
    }

    public static class DruidQueryGeneratorResult {
        private final GeneratedDql generateddql;
        private final DruidQueryGeneratorContext context;

        public DruidQueryGeneratorResult(GeneratedDql generateddql, DruidQueryGeneratorContext context) {
            this.generateddql = Objects.requireNonNull(generateddql, "generateddql is null");
            this.context = Objects.requireNonNull(context, "context is null");
        }

        public GeneratedDql getGeneratedDql() {
            return this.generateddql;
        }

        public DruidQueryGeneratorContext getContext() {
            return this.context;
        }
    }
}

