/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.druid.DruidAggregationColumnNode;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DruidPushdownUtils {
    public static final String DRUID_COUNT_DISTINCT_FUNCTION_NAME = "distinctCount";
    private static final String COUNT_FUNCTION_NAME = "count";
    private static final String DISTINCT_MASK = "$distinct";

    private DruidPushdownUtils() {
    }

    public static List<DruidAggregationColumnNode> computeAggregationNodes(AggregationNode aggregationNode) {
        int groupByKeyIndex = 0;
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        for (VariableReferenceExpression outputColumn : aggregationNode.getOutputVariables()) {
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)aggregationNode.getAggregations().get(outputColumn);
            if (aggregation != null) {
                if (aggregation.getFilter().isPresent() || aggregation.isDistinct() || aggregation.getOrderBy().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported aggregation node " + aggregationNode);
                }
                if (aggregation.getMask().isPresent()) {
                    if (aggregation.getCall().getDisplayName().equalsIgnoreCase(COUNT_FUNCTION_NAME) && ((VariableReferenceExpression)aggregation.getMask().get()).getName().equalsIgnoreCase(aggregation.getArguments().get(0) + DISTINCT_MASK)) {
                        nodeBuilder.add((Object)new DruidAggregationColumnNode.AggregationFunctionColumnNode(outputColumn, new CallExpression(DRUID_COUNT_DISTINCT_FUNCTION_NAME, aggregation.getCall().getFunctionHandle(), aggregation.getCall().getType(), aggregation.getCall().getArguments())));
                        continue;
                    }
                    throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported aggregation node with mask " + aggregationNode);
                }
                if (DruidPushdownUtils.handlePushDownSingleDistinctCount((ImmutableList.Builder<DruidAggregationColumnNode>)nodeBuilder, aggregationNode, outputColumn, aggregation)) continue;
                nodeBuilder.add((Object)new DruidAggregationColumnNode.AggregationFunctionColumnNode(outputColumn, aggregation.getCall()));
                continue;
            }
            VariableReferenceExpression inputColumn = (VariableReferenceExpression)aggregationNode.getGroupingKeys().get(groupByKeyIndex);
            nodeBuilder.add((Object)new DruidAggregationColumnNode.GroupByColumnNode(inputColumn, outputColumn));
            ++groupByKeyIndex;
        }
        return nodeBuilder.build();
    }

    private static boolean handlePushDownSingleDistinctCount(ImmutableList.Builder<DruidAggregationColumnNode> nodeBuilder, AggregationNode aggregationNode, VariableReferenceExpression outputColumn, AggregationNode.Aggregation aggregation) {
        if (!aggregation.getCall().getDisplayName().equalsIgnoreCase(COUNT_FUNCTION_NAME)) {
            return false;
        }
        List arguments = aggregation.getCall().getArguments();
        if (arguments.size() != 1) {
            return false;
        }
        RowExpression aggregationArgument = (RowExpression)arguments.get(0);
        if (!(aggregationNode.getSource() instanceof AggregationNode)) {
            return false;
        }
        AggregationNode sourceAggregationNode = (AggregationNode)aggregationNode.getSource();
        Set<String> sourceAggregationGroupSet = DruidPushdownUtils.getGroupKeys(sourceAggregationNode.getGroupingKeys());
        Set<String> aggregationGroupSet = DruidPushdownUtils.getGroupKeys(aggregationNode.getGroupingKeys());
        aggregationGroupSet.add(aggregationArgument.toString());
        if (!sourceAggregationGroupSet.containsAll(aggregationGroupSet) && aggregationGroupSet.containsAll(sourceAggregationGroupSet)) {
            return false;
        }
        nodeBuilder.add((Object)new DruidAggregationColumnNode.AggregationFunctionColumnNode(outputColumn, new CallExpression(DRUID_COUNT_DISTINCT_FUNCTION_NAME, aggregation.getFunctionHandle(), aggregation.getCall().getType(), (List)ImmutableList.of((Object)aggregationArgument))));
        return true;
    }

    private static Set<String> getGroupKeys(List<VariableReferenceExpression> groupingKeys) {
        HashSet<String> groupKeySet = new HashSet<String>();
        groupingKeys.forEach(groupingKey -> groupKeySet.add(groupingKey.getName()));
        return groupKeySet;
    }

    private static Number decodeDecimal(BigInteger unscaledValue, DecimalType type) {
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    public static String getLiteralAsString(ConstantExpression node) {
        Type type = node.getType();
        if (node.getValue() == null) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Null constant expression: " + node + " with value of type: " + type);
        }
        if (type instanceof BooleanType) {
            return String.valueOf((Boolean)node.getValue());
        }
        if (type instanceof BigintType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType) {
            Number number = (Number)node.getValue();
            return String.format("%d", number.longValue());
        }
        if (type instanceof DoubleType) {
            return node.getValue().toString();
        }
        if (type instanceof RealType) {
            Long number = (Long)node.getValue();
            return String.format("%f", Float.valueOf(Float.intBitsToFloat(number.intValue())));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                Preconditions.checkState((boolean)(node.getValue() instanceof Long));
                return DruidPushdownUtils.decodeDecimal(BigInteger.valueOf((Long)node.getValue()), decimalType).toString();
            }
            Preconditions.checkState((boolean)(node.getValue() instanceof Slice));
            Slice value = (Slice)node.getValue();
            return DruidPushdownUtils.decodeDecimal(Decimals.decodeUnscaledValue((Slice)value), decimalType).toString();
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return "'" + ((Slice)node.getValue()).toStringUtf8() + "'";
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Cannot handle the constant expression: " + node + " with value of type: " + type);
    }
}

