/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DataInputSourceId;
import com.facebook.presto.druid.DruidBrokerPageSource;
import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidSegmentPageSource;
import com.facebook.presto.druid.DruidSplit;
import com.facebook.presto.druid.metadata.DruidSegmentInfo;
import com.facebook.presto.druid.segment.DruidSegmentReader;
import com.facebook.presto.druid.segment.HdfsDataInputSource;
import com.facebook.presto.druid.segment.SmooshedColumnSource;
import com.facebook.presto.druid.segment.V9SegmentIndexSource;
import com.facebook.presto.druid.segment.ZipIndexFileSource;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DruidPageSourceProvider
implements ConnectorPageSourceProvider {
    private final DruidClient druidClient;
    private final Configuration hadoopConfiguration;

    @Inject
    public DruidPageSourceProvider(DruidClient druidClient, DruidConfig config) {
        this.druidClient = Objects.requireNonNull(druidClient, "druid client is null");
        this.hadoopConfiguration = DruidPageSourceProvider.readConfiguration(config.getHadoopConfiguration());
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        DruidSplit druidSplit = (DruidSplit)split;
        if (druidSplit.getSplitType() == DruidSplit.SplitType.BROKER) {
            return new DruidBrokerPageSource(druidSplit.getBrokerDql().get(), columns, this.druidClient);
        }
        DruidSegmentInfo segmentInfo = druidSplit.getSegmentInfo().get();
        try {
            Path hdfsPath = new Path(segmentInfo.getDeepStoragePath());
            FileSystem fileSystem = hdfsPath.getFileSystem(this.hadoopConfiguration);
            long fileSize = fileSystem.getFileStatus(hdfsPath).getLen();
            FSDataInputStream inputStream = fileSystem.open(hdfsPath);
            DataInputSourceId dataInputSourceId = new DataInputSourceId(hdfsPath.toString());
            HdfsDataInputSource dataInputSource = new HdfsDataInputSource(dataInputSourceId, inputStream, fileSize);
            ZipIndexFileSource indexFileSource = new ZipIndexFileSource(dataInputSource);
            SmooshedColumnSource segmentColumnSource = new SmooshedColumnSource(indexFileSource);
            V9SegmentIndexSource segmentIndexSource = new V9SegmentIndexSource(segmentColumnSource);
            return new DruidSegmentPageSource(dataInputSource, columns, new DruidSegmentReader(segmentIndexSource, columns));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_DEEP_STORAGE_ERROR, "Failed to create page source on " + segmentInfo.getDeepStoragePath(), (Throwable)e);
        }
    }

    private static Configuration readConfiguration(List<String> resourcePaths) {
        Configuration configuration = new Configuration(false);
        for (String resourcePath : resourcePaths) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            for (Map.Entry entry : resourceProperties) {
                configuration.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return configuration;
    }
}

