/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidExpression;
import com.facebook.presto.druid.DruidPushdownUtils;
import com.facebook.presto.druid.DruidQueryGeneratorContext;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DruidFilterExpressionConverter
implements RowExpressionVisitor<DruidExpression, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection>> {
    private static final Set<String> LOGICAL_BINARY_OPS_FILTER = ImmutableSet.of((Object)"=", (Object)"<", (Object)"<=", (Object)">", (Object)">=", (Object)"<>", (Object[])new String[0]);
    private static final String TIMESTAMP_LITERAL = "$literal$timestamp";
    private final TypeManager typeManager;
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;
    private final ConnectorSession session;

    public DruidFilterExpressionConverter(TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution, ConnectorSession session) {
        this.typeManager = Objects.requireNonNull(typeManager, "type manager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function metadata manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    private DruidExpression handleIn(SpecialFormExpression specialForm, boolean isWhitelist, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        return DruidExpression.derived(String.format("(%s %s (%s))", ((DruidExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), isWhitelist ? "IN" : "NOT IN", specialForm.getArguments().subList(1, specialForm.getArguments().size()).stream().map(argument -> ((DruidExpression)argument.accept((RowExpressionVisitor)this, (Object)context)).getDefinition()).collect(Collectors.joining(", "))));
    }

    private DruidExpression handleLogicalBinary(String operator, CallExpression call, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        if (!LOGICAL_BINARY_OPS_FILTER.contains(operator)) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, operator + " is not supported in Druid filter");
        }
        List arguments = call.getArguments();
        if (arguments.size() == 2) {
            return DruidExpression.derived(String.format("(%s %s %s)", ((DruidExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), operator, ((DruidExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, context)).getDefinition()));
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unknown logical binary: " + call);
    }

    private DruidExpression handleBetween(CallExpression between, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        if (between.getArguments().size() == 3) {
            RowExpression value = (RowExpression)between.getArguments().get(0);
            RowExpression min = (RowExpression)between.getArguments().get(1);
            RowExpression max = (RowExpression)between.getArguments().get(2);
            return DruidExpression.derived(String.format("(%s BETWEEN %s AND %s)", ((DruidExpression)value.accept((RowExpressionVisitor)this, context)).getDefinition(), ((DruidExpression)min.accept((RowExpressionVisitor)this, context)).getDefinition(), ((DruidExpression)max.accept((RowExpressionVisitor)this, context)).getDefinition()));
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Between operator not supported: " + between);
    }

    private DruidExpression handleNot(CallExpression not, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        SpecialFormExpression specialFormExpression;
        RowExpression input;
        if (not.getArguments().size() == 1 && (input = (RowExpression)not.getArguments().get(0)) instanceof SpecialFormExpression && (specialFormExpression = (SpecialFormExpression)input).getForm() == SpecialFormExpression.Form.IN) {
            return this.handleIn(specialFormExpression, false, context);
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "NOT operator is supported only on top of IN operator. Received: " + not);
    }

    private DruidExpression handleCast(CallExpression cast, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        if (cast.getArguments().size() == 1) {
            RowExpression input = (RowExpression)cast.getArguments().get(0);
            Type expectedType = cast.getType();
            if (this.typeManager.canCoerce(input.getType(), expectedType)) {
                return (DruidExpression)input.accept((RowExpressionVisitor)this, context);
            }
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Non implicit casts not supported: " + cast);
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "This type of CAST operator not supported: " + cast);
    }

    public DruidExpression visitCall(CallExpression call, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        if (this.standardFunctionResolution.isNotFunction(functionHandle)) {
            return this.handleNot(call, context);
        }
        if (this.standardFunctionResolution.isCastFunction(functionHandle)) {
            return this.handleCast(call, context);
        }
        if (this.standardFunctionResolution.isBetweenFunction(functionHandle)) {
            return this.handleBetween(call, context);
        }
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(call.getFunctionHandle());
        Optional operatorTypeOptional = functionMetadata.getOperatorType();
        if (operatorTypeOptional.isPresent()) {
            OperatorType operatorType = (OperatorType)operatorTypeOptional.get();
            if (operatorType.isArithmeticOperator()) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Arithmetic expressions are not supported in Druid filter: " + call);
            }
            if (operatorType.isComparisonOperator()) {
                return this.handleLogicalBinary(operatorType.getOperator(), call, context);
            }
        }
        if (call.getDisplayName().toLowerCase(Locale.ENGLISH).equals(TIMESTAMP_LITERAL) && call.getArguments().size() == 1 && call.getType().getDisplayName().equals("timestamp")) {
            RowExpression argument = (RowExpression)call.getArguments().get(0);
            if (!(argument instanceof ConstantExpression)) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Invalid Timestamp literal in Druid filter: " + argument.toString());
            }
            SqlTimestamp value = new SqlTimestamp(((Long)((ConstantExpression)argument).getValue()).longValue(), this.session.getSqlFunctionProperties().getTimeZoneKey());
            return new DruidExpression("'" + value.toString() + "'", DruidQueryGeneratorContext.Origin.LITERAL);
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Function " + call + " not supported in Druid filter");
    }

    public DruidExpression visitInputReference(InputReferenceExpression reference, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Druid does not support struct dereference: " + reference);
    }

    public DruidExpression visitConstant(ConstantExpression literal, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        return new DruidExpression(DruidPushdownUtils.getLiteralAsString(literal), DruidQueryGeneratorContext.Origin.LITERAL);
    }

    public DruidExpression visitLambda(LambdaDefinitionExpression lambda, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Druid does not support lambda: " + lambda);
    }

    public DruidExpression visitVariableReference(VariableReferenceExpression reference, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        DruidQueryGeneratorContext.Selection input = Objects.requireNonNull(context.apply(reference), String.format("Input column %s does not exist in the input: %s", reference, context));
        return new DruidExpression(input.getEscapedDefinition(), input.getOrigin());
    }

    public DruidExpression visitSpecialForm(SpecialFormExpression specialForm, Function<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        switch (specialForm.getForm()) {
            case IF: 
            case NULL_IF: 
            case SWITCH: 
            case WHEN: 
            case IS_NULL: 
            case COALESCE: 
            case DEREFERENCE: 
            case ROW_CONSTRUCTOR: 
            case BIND: {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Druid does not support special form: " + specialForm);
            }
            case IN: {
                return this.handleIn(specialForm, true, context);
            }
            case AND: 
            case OR: {
                return DruidExpression.derived(String.format("(%s %s %s)", ((DruidExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), specialForm.getForm().toString(), ((DruidExpression)((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, context)).getDefinition()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Druid does not support special form: " + specialForm);
    }
}

