/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.druid.DruidMetadata;
import com.facebook.presto.druid.DruidPageSourceProvider;
import com.facebook.presto.druid.DruidPlanOptimizer;
import com.facebook.presto.druid.DruidPlanOptimizerProvider;
import com.facebook.presto.druid.DruidSessionProperties;
import com.facebook.presto.druid.DruidSplitManager;
import com.facebook.presto.druid.DruidTransactionHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class DruidConnector
implements Connector {
    private static final Logger log = Logger.get(DruidConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final DruidMetadata metadata;
    private final DruidSplitManager splitManager;
    private final DruidPageSourceProvider pageSourceProvider;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final ConnectorPlanOptimizer planOptimizer;

    @Inject
    public DruidConnector(LifeCycleManager lifeCycleManager, DruidMetadata metadata, DruidSplitManager splitManager, DruidPageSourceProvider pageSourceProvider, DruidSessionProperties druidSessionProperties, DruidPlanOptimizer planOptimizer) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.sessionProperties = ImmutableList.copyOf(Objects.requireNonNull(druidSessionProperties, "sessionProperties is null").getSessionProperties());
        this.planOptimizer = Objects.requireNonNull(planOptimizer, "plan optimizer is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return DruidTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return new DruidPlanOptimizerProvider(this.planOptimizer);
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

