/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.metadata;

import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class DruidSegmentInfo {
    private static final String DEEP_STORAGE_TYPE_KEY = "type";
    private static final String SEGMENT_PATH_KEY = "path";
    private final String dataSource;
    private final Interval interval;
    private final String version;
    private final Optional<Map<String, String>> loadSpecification;
    private final Optional<Map<String, String>> shardSpecification;
    private final Integer binaryVersion;
    private final long size;

    @JsonCreator
    public DruidSegmentInfo(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="loadSpec") Optional<Map<String, String>> loadSpecification, @JsonProperty(value="shardSpec") @Nullable Optional<Map<String, String>> shardSpecification, @JsonProperty(value="binaryVersion") Integer binaryVersion, @JsonProperty(value="size") long size) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.interval = Objects.requireNonNull(interval, "interval is null");
        this.version = Objects.requireNonNull(version, "version is null");
        this.loadSpecification = Objects.requireNonNull(loadSpecification, "loadSpecification is null");
        this.shardSpecification = Objects.requireNonNull(shardSpecification, "shardSpecification is null");
        this.binaryVersion = Objects.requireNonNull(binaryVersion, "binaryVersion is null");
        this.size = size;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public Optional<Map<String, String>> getLoadSpecification() {
        return this.loadSpecification;
    }

    @JsonProperty
    public Optional<Map<String, String>> getShardSpecification() {
        return this.shardSpecification;
    }

    @JsonProperty
    public Integer getBinaryVersion() {
        return this.binaryVersion;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    public DeepStorageType getDeepStorageType() {
        Map<String, String> loadSpecification = this.getLoadSpecification().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_METADATA_ERROR, String.format("Malformed segment loadSpecification: %s", this.getLoadSpecification())));
        return DeepStorageType.valueOf(loadSpecification.get(DEEP_STORAGE_TYPE_KEY).toUpperCase());
    }

    public String getDeepStoragePath() {
        Map<String, String> loadSpecification = this.getLoadSpecification().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_METADATA_ERROR, String.format("Malformed segment loadSpecification: %s", this.getLoadSpecification())));
        return loadSpecification.get(SEGMENT_PATH_KEY);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.interval, this.version, this.loadSpecification, this.shardSpecification, this.binaryVersion, this.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DruidSegmentInfo that = (DruidSegmentInfo)obj;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.interval, that.interval) && Objects.equals(this.version, that.version) && Objects.equals(this.loadSpecification, that.loadSpecification) && Objects.equals(this.shardSpecification, that.shardSpecification) && Objects.equals(this.binaryVersion, that.binaryVersion) && Objects.equals(this.size, that.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataSource", (Object)this.dataSource).add("interval", (Object)this.interval).add("version", (Object)this.version).add("loadSpecification", this.loadSpecification).add("shardSpecification", this.shardSpecification).add("binaryVersion", (Object)this.binaryVersion).add("size", this.size).toString();
    }

    public static enum DeepStorageType {
        HDFS("hdfs");

        private final String type;

        private DeepStorageType(String type) {
            this.type = type;
        }
    }
}

