/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.column;

import com.facebook.presto.druid.column.ColumnReader;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.segment.ColumnValueSelector;

public class TimestampColumnReader
implements ColumnReader {
    private final ColumnValueSelector<Long> valueSelector;

    public TimestampColumnReader(ColumnValueSelector valueSelector) {
        this.valueSelector = Objects.requireNonNull(valueSelector, "value selector is null");
    }

    @Override
    public Block readBlock(Type type, int batchSize) {
        Preconditions.checkArgument((type == TimestampType.TIMESTAMP ? 1 : 0) != 0);
        BlockBuilder builder = type.createBlockBuilder(null, batchSize);
        for (int i = 0; i < batchSize; ++i) {
            type.writeLong(builder, this.valueSelector.getLong());
        }
        return builder.build();
    }
}

