/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.column;

import com.facebook.presto.druid.column.ColumnReader;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import java.util.Objects;
import org.apache.druid.segment.ColumnValueSelector;

public class StringColumnReader
implements ColumnReader {
    private final ColumnValueSelector<String> valueSelector;

    public StringColumnReader(ColumnValueSelector valueSelector) {
        this.valueSelector = Objects.requireNonNull(valueSelector, "value selector is null");
    }

    @Override
    public Block readBlock(Type type, int batchSize) {
        Preconditions.checkArgument((type == VarcharType.VARCHAR ? 1 : 0) != 0);
        BlockBuilder builder = type.createBlockBuilder(null, batchSize);
        for (int i = 0; i < batchSize; ++i) {
            String value = (String)this.valueSelector.getObject();
            if (value != null) {
                type.writeSlice(builder, Slices.utf8Slice((String)value));
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }
}

